/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import javax.annotation.Nonnull;
import me.shedaniel.clothconfig2.forge.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.forge.api.ConfigBuilder;
import me.shedaniel.clothconfig2.forge.api.ConfigCategory;
import me.shedaniel.clothconfig2.forge.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.forge.impl.builders.SubCategoryBuilder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.dsurround.config.Config;
import org.orecruncher.dsurround.huds.lightlevel.LightLevelHUD;
import org.orecruncher.environs.config.ConfigGenerator;
import org.orecruncher.lib.config.ClothAPIFactory;

@OnlyIn(value=Dist.CLIENT)
public class ConfigMenuBuilder
extends ClothAPIFactory {
    public ConfigMenuBuilder() {
        super((ITextComponent)new TranslationTextComponent("dsurround.modname"), () -> {
            Config.SPEC.save();
            org.orecruncher.sndctrl.config.Config.SPEC.save();
            org.orecruncher.environs.config.Config.SPEC.save();
            org.orecruncher.mobeffects.config.Config.SPEC.save();
        }, new ResourceLocation("minecraft:textures/block/cobblestone.png"));
    }

    @Override
    protected void generate(@Nonnull ConfigBuilder builder) {
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory category = ConfigMenuBuilder.createRootCategory(builder);
        SubCategoryBuilder modRoot = ConfigMenuBuilder.createSubCategory(entryBuilder, "dsurround.modname", TextFormatting.GOLD, false);
        SubCategoryBuilder subCategory = ConfigMenuBuilder.createSubCategory(entryBuilder, "dsurround.cfg.logging", TextFormatting.YELLOW, false);
        subCategory.add((AbstractConfigListEntry)ConfigMenuBuilder.createBoolean(builder, Config.CLIENT.logging.onlineVersionCheck));
        subCategory.add((AbstractConfigListEntry)ConfigMenuBuilder.createBoolean(builder, Config.CLIENT.logging.enableLogging));
        subCategory.add((AbstractConfigListEntry)ConfigMenuBuilder.createInteger(builder, Config.CLIENT.logging.flagMask));
        modRoot.add((AbstractConfigListEntry)subCategory.build());
        subCategory = ConfigMenuBuilder.createSubCategory(entryBuilder, "dsurround.cfg.lightlevel", TextFormatting.YELLOW, false);
        subCategory.add(ConfigMenuBuilder.createEnumList(builder, LightLevelHUD.ColorSet.class, Config.CLIENT.lightLevel.colorSet));
        subCategory.add(ConfigMenuBuilder.createEnumList(builder, LightLevelHUD.Mode.class, Config.CLIENT.lightLevel.mode));
        subCategory.add((AbstractConfigListEntry)ConfigMenuBuilder.createInteger(builder, Config.CLIENT.lightLevel.range));
        subCategory.add((AbstractConfigListEntry)ConfigMenuBuilder.createInteger(builder, Config.CLIENT.lightLevel.lightSpawnThreshold));
        subCategory.add((AbstractConfigListEntry)ConfigMenuBuilder.createBoolean(builder, Config.CLIENT.lightLevel.hideSafe));
        modRoot.add((AbstractConfigListEntry)subCategory.build());
        category.addEntry((AbstractConfigListEntry)modRoot.build());
        category.addEntry((AbstractConfigListEntry)org.orecruncher.sndctrl.config.ConfigGenerator.generate(builder, entryBuilder).build());
        category.addEntry((AbstractConfigListEntry)ConfigGenerator.generate(builder, entryBuilder).build());
        category.addEntry((AbstractConfigListEntry)org.orecruncher.mobeffects.config.ConfigGenerator.generate(builder, entryBuilder).build());
    }
}

