/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.huds.lightlevel;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.orecruncher.dsurround.DynamicSurroundings;
import org.orecruncher.dsurround.config.Config;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.gui.Color;
import org.orecruncher.lib.gui.ColorPalette;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.particles.FrustumHelper;

@Mod.EventBusSubscriber(modid="dsurround", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LightLevelHUD {
    private static FontRenderer font;
    private static boolean showHUD;
    private static final int ALLOCATION_SIZE = 2048;
    private static final ObjectArray<LightCoord> lightLevels;
    private static final BlockPos.Mutable mutable;
    private static int nextCoord;
    private static final String[] lightLevelText;
    private static final int[] margins;

    private static LightCoord nextCoord() {
        if (nextCoord == lightLevels.size()) {
            lightLevels.add(new LightCoord());
        }
        return lightLevels.get(nextCoord++);
    }

    protected static boolean inFrustum(double x, double y, double z) {
        return FrustumHelper.isLocationInFrustum(new Vector3d(x, y, z));
    }

    protected static boolean renderLightLevel(@Nonnull BlockState state, @Nonnull BlockState below) {
        Material stateMaterial = state.func_185904_a();
        Material belowMaterial = below.func_185904_a();
        return !stateMaterial.func_76220_a() && !stateMaterial.func_76224_d() && belowMaterial.func_76220_a();
    }

    protected static float heightAdjustment(@Nonnull BlockState state, @Nonnull BlockState below, @Nonnull BlockPos pos) {
        if (state.func_185904_a() == Material.field_151579_a) {
            VoxelShape shape = below.func_196952_d((IBlockReader)GameUtils.getWorld(), pos.func_177977_b());
            return shape.func_197766_b() ? 0.0f : (float)shape.func_197758_c(Direction.Axis.Y) - 1.0f;
        }
        VoxelShape shape = below.func_196952_d((IBlockReader)GameUtils.getWorld(), pos);
        if (shape.func_197766_b()) {
            return 0.0f;
        }
        float adjust = (float)shape.func_197758_c(Direction.Axis.Y);
        return state.func_177230_c() == Blocks.field_150433_aE ? adjust + 0.125f : adjust;
    }

    protected static void updateLightInfo(@Nonnull Vector3d position) {
        FontRenderer fr = GameUtils.getMC().field_71466_p;
        if (fr != font) {
            font = fr;
            for (int i = 0; i < 16; ++i) {
                LightLevelHUD.margins[i] = -(font.func_78256_a(lightLevelText[i]) + 1) / 2;
            }
        }
        nextCoord = 0;
        ColorSet colors = (ColorSet)((Object)Config.CLIENT.lightLevel.colorSet.get());
        Mode displayMode = (Mode)((Object)Config.CLIENT.lightLevel.mode.get());
        int skyLightSub = GameUtils.getWorld().func_175657_ab();
        int rangeXZ = (Integer)Config.CLIENT.lightLevel.range.get() * 2 + 1;
        int rangeY = (Integer)Config.CLIENT.lightLevel.range.get() + 1;
        int originX = MathStuff.floor(position.field_72450_a) - rangeXZ / 2;
        int originZ = MathStuff.floor(position.field_72449_c) - rangeXZ / 2;
        int originY = MathStuff.floor(position.field_72448_b) - (rangeY - 3);
        ClientWorld world = GameUtils.getWorld();
        for (int dX = 0; dX < rangeXZ; ++dX) {
            for (int dZ = 0; dZ < rangeXZ; ++dZ) {
                int trueX = originX + dX;
                int trueZ = originZ + dZ;
                BlockState lastState = null;
                for (int dY = 0; dY < rangeY; ++dY) {
                    int trueY = originY + dY;
                    if (trueY < 1 || !LightLevelHUD.inFrustum(trueX, trueY, trueZ)) continue;
                    BlockPos pos = new BlockPos(trueX, trueY, trueZ);
                    BlockState state = world.func_180495_p(pos);
                    if (lastState == null) {
                        lastState = world.func_180495_p(pos.func_177977_b());
                    }
                    if (LightLevelHUD.renderLightLevel(state, lastState)) {
                        mutable.func_181079_c(trueX, trueY, trueZ);
                        boolean mobSpawn = lastState.canCreatureSpawn((IWorldReader)GameUtils.getWorld(), (BlockPos)mutable, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, EntityType.field_200725_aD);
                        if (mobSpawn || !((Boolean)Config.CLIENT.lightLevel.hideSafe.get()).booleanValue()) {
                            int blockLight = world.func_226658_a_(LightType.BLOCK, (BlockPos)mutable);
                            int skyLight = world.func_226658_a_(LightType.SKY, (BlockPos)mutable) - skyLightSub;
                            int effective = Math.max(blockLight, skyLight);
                            int result = displayMode == Mode.BLOCK_SKY ? effective : (displayMode == Mode.BLOCK ? blockLight : skyLight);
                            Color color = colors.safe;
                            if (!mobSpawn) {
                                color = colors.noSpawn;
                            } else if (blockLight <= (Integer)Config.CLIENT.lightLevel.lightSpawnThreshold.get()) {
                                color = effective > (Integer)Config.CLIENT.lightLevel.lightSpawnThreshold.get() ? colors.caution : colors.hazard;
                            }
                            if (color != colors.safe || !((Boolean)Config.CLIENT.lightLevel.hideSafe.get()).booleanValue()) {
                                LightCoord coord = LightLevelHUD.nextCoord();
                                coord.x = trueX;
                                coord.y = (double)((float)trueY + LightLevelHUD.heightAdjustment(state, lastState, (BlockPos)mutable)) + 0.002;
                                coord.z = trueZ;
                                coord.lightLevel = result;
                                coord.color = color.rgbWithAlpha(254);
                            }
                        }
                    }
                    lastState = state;
                }
            }
        }
    }

    public static void toggleDisplay() {
        showHUD = !showHUD;
        DynamicSurroundings.LOGGER.info("Light Level HUD: %s", Boolean.toString(showHUD));
    }

    @SubscribeEvent
    public static void doTick(@Nonnull TickEvent.PlayerTickEvent event) {
        if (!showHUD || event.side == LogicalSide.SERVER || event.phase == TickEvent.Phase.END || GameUtils.getMC().func_147113_T()) {
            return;
        }
        if (event.player == null || event.player.field_70170_p == null) {
            return;
        }
        if (TickCounter.getTickCount() % 4L != 0L) {
            return;
        }
        LightLevelHUD.updateLightInfo(event.player.func_213303_ch());
    }

    public static void render(@Nonnull MatrixStack matrixStack, float partialTicks) {
        if (!showHUD || nextCoord == 0) {
            return;
        }
        PlayerEntity player = GameUtils.getPlayer();
        if (player == null) {
            return;
        }
        LightLevelHUD.drawStringRender(matrixStack, player);
    }

    private static void drawStringRender(@Nonnull MatrixStack matrixStack, @Nonnull PlayerEntity player) {
        boolean thirdPerson = GameUtils.isThirdPersonView();
        Direction playerFacing = player.func_174811_aO();
        if (thirdPerson) {
            playerFacing = playerFacing.func_176734_d();
        }
        if (playerFacing == Direction.SOUTH || playerFacing == Direction.NORTH) {
            playerFacing = playerFacing.func_176734_d();
        }
        float rotationAngle = playerFacing.func_176734_d().func_185119_l();
        Quaternion rotY = Vector3f.field_229181_d_.func_229187_a_(rotationAngle);
        Quaternion rotX = Vector3f.field_229179_b_.func_229187_a_(90.0f);
        Vector3d view = GameUtils.getMC().field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-view.func_82615_a(), -view.func_82617_b(), -view.func_82616_c());
        RenderSystem.disableLighting();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.depthMask((boolean)true);
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        font.getClass();
        int yAdjust = -(9 / 2);
        for (int i = 0; i < nextCoord; ++i) {
            LightCoord coord = lightLevels.get(i);
            String text = lightLevelText[coord.lightLevel];
            int margin = margins[coord.lightLevel];
            float scale = 0.07f;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)coord.x + 0.5, coord.y, (double)coord.z + 0.5);
            matrixStack.func_227863_a_(rotY);
            matrixStack.func_227863_a_(rotX);
            matrixStack.func_227862_a_(-0.07f, -0.07f, 0.07f);
            font.func_228079_a_(text, (float)margin, (float)yAdjust, coord.color, false, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
            matrixStack.func_227865_b_();
        }
        buffer.func_228461_a_();
        matrixStack.func_227865_b_();
    }

    static {
        int i;
        showHUD = false;
        lightLevels = new ObjectArray(2048);
        mutable = new BlockPos.Mutable();
        nextCoord = 0;
        lightLevelText = new String[16];
        margins = new int[16];
        for (i = 0; i < 2048; ++i) {
            lightLevels.add(new LightCoord());
        }
        for (i = 0; i < 16; ++i) {
            LightLevelHUD.lightLevelText[i] = String.valueOf(i);
        }
    }

    private static final class LightCoord {
        public int x;
        public double y;
        public int z;
        public int lightLevel;
        public int color;

        private LightCoord() {
        }
    }

    public static enum ColorSet {
        BRIGHT(ColorPalette.MC_GREEN, ColorPalette.MC_YELLOW, ColorPalette.MC_RED, ColorPalette.MC_DARKAQUA),
        DARK(ColorPalette.MC_DARKGREEN, ColorPalette.MC_GOLD, ColorPalette.MC_DARKRED, ColorPalette.MC_DARKBLUE);

        public final Color safe;
        public final Color caution;
        public final Color hazard;
        public final Color noSpawn;

        private ColorSet(@Nonnull Color safe, @Nonnull Color caution, Color hazard, Color noSpawn) {
            this.safe = safe;
            this.caution = caution;
            this.hazard = hazard;
            this.noSpawn = noSpawn;
        }
    }

    public static enum Mode {
        BLOCK,
        SKY,
        BLOCK_SKY;

    }
}

