/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects.emitters;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.random.XorShiftRandom;

@OnlyIn(value=Dist.CLIENT)
public abstract class ParticleEmitter {
    protected static final Random RANDOM = XorShiftRandom.current();
    protected final IBlockReader world;
    protected final double posX;
    protected final double posY;
    protected final double posZ;
    protected final BlockPos position;
    private boolean isAlive = true;

    protected ParticleEmitter(IBlockReader worldIn, double posXIn, double posYIn, double posZIn) {
        this.world = worldIn;
        this.posX = posXIn;
        this.posY = posYIn;
        this.posZ = posZIn;
        this.position = new BlockPos(posXIn, posYIn, posZIn);
    }

    @Nonnull
    public BlockPos getPos() {
        return this.position;
    }

    public void addParticle(@Nonnull Particle particle) {
        GameUtils.getMC().field_71452_i.func_78873_a(particle);
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void setExpired() {
        this.isAlive = false;
        this.cleanUp();
    }

    public boolean shouldDie() {
        return false;
    }

    protected void cleanUp() {
    }

    public void tick() {
        if (this.shouldDie()) {
            this.setExpired();
            return;
        }
        this.think();
        if (this.isAlive()) {
            this.soundUpdate();
        }
    }

    protected void soundUpdate() {
    }

    public abstract void think();
}

