/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.scanner;

import java.util.Collection;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.BlockEffect;
import org.orecruncher.environs.library.BlockStateData;
import org.orecruncher.environs.library.BlockStateUtil;
import org.orecruncher.environs.scanner.RandomScanner;
import org.orecruncher.environs.scanner.ScanContext;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;

@OnlyIn(value=Dist.CLIENT)
public class RandomBlockEffectScanner
extends RandomScanner {
    private static final int ITERATION_COUNT = 667;
    public static final int NEAR_RANGE = 16;
    public static final int FAR_RANGE = 32;

    public RandomBlockEffectScanner(@Nonnull ScanContext locus, int range) {
        super(locus, "RandomBlockScanner: " + range, range, 667);
    }

    @Override
    protected boolean interestingBlock(@Nonnull BlockState state) {
        return BlockStateUtil.getData(state).hasSoundsOrEffects();
    }

    @Override
    public void blockScan(@Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random rand) {
        IBlockReader world = this.locus.getWorld();
        BlockStateData profile = BlockStateUtil.getData(state);
        Collection<BlockEffect> effects = profile.getEffects();
        for (BlockEffect be : effects) {
            if (!be.canTrigger(world, state, pos, rand)) continue;
            be.doEffect(world, state, pos, rand);
        }
        IAcoustic sound = profile.getSoundToPlay(rand);
        if (sound != null) {
            sound.playAt(pos);
        }
    }
}

