/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.effects;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.Lib;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.effects.EntityEffectManager;
import org.orecruncher.lib.effects.entity.CapabilityEntityFXData;
import org.orecruncher.lib.effects.entity.IEntityFX;
import org.orecruncher.lib.events.DiagnosticEvent;
import org.orecruncher.lib.math.LoggingTimerEMA;
import org.orecruncher.sndctrl.api.effects.AbstractEntityEffect;
import org.orecruncher.sndctrl.config.Config;
import org.orecruncher.sndctrl.library.EntityEffectLibrary;

@Mod.EventBusSubscriber(modid="dsurround", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class EntityEffectHandler {
    private static final LoggingTimerEMA timer = new LoggingTimerEMA("Entity Effect Update");
    private static long nanos;

    private EntityEffectHandler() {
    }

    public static void initialize() {
    }

    @Nonnull
    private static Optional<EntityEffectManager> create(@Nonnull LivingEntity entity) {
        ObjectArray<AbstractEntityEffect> effectToApply = EntityEffectLibrary.getEffects(entity);
        EntityEffectManager result = effectToApply.size() > 0 ? new EntityEffectManager(entity, effectToApply) : new EntityEffectManager(entity);
        return Optional.of(result);
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void onLivingUpdate(@Nonnull LivingEvent.LivingUpdateEvent event) {
        try {
            LivingEntity entity = event.getEntityLiving();
            if (entity != null && entity.func_130014_f_().field_72995_K) {
                IProfiler profiler = GameUtils.getMC().func_213239_aq();
                profiler.func_76320_a("MobEffects Living Update");
                long start = System.nanoTime();
                entity.getCapability(CapabilityEntityFXData.FX_INFO).ifPresent(cap -> {
                    int range = (Integer)Config.CLIENT.effects.effectRange.get();
                    int effectDistSq = range * range;
                    boolean inRange = entity.func_70068_e((Entity)GameUtils.getPlayer()) <= (double)effectDistSq;
                    EntityEffectManager mgr = cap.get();
                    if (mgr != null && !inRange) {
                        cap.clear();
                    } else if (mgr == null && inRange && entity.func_70089_S()) {
                        cap.set(EntityEffectHandler.create(entity).get());
                    } else if (mgr != null) {
                        mgr.update();
                    }
                });
                nanos += System.nanoTime() - start;
                profiler.func_76319_b();
            }
        }
        catch (Throwable t) {
            Lib.LOGGER.error(t, "Error ticking entity %s!", new Object[0]);
        }
    }

    private static void clearHandlers() {
        Iterable entities = GameUtils.getWorld().func_217416_b();
        for (Entity e : entities) {
            e.getCapability(CapabilityEntityFXData.FX_INFO).ifPresent(IEntityFX::clear);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityJoin(@Nonnull EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && GameUtils.getPlayer() == event.getEntity()) {
            EntityEffectHandler.clearHandlers();
        }
    }

    @SubscribeEvent
    public static void onClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        timer.update(nanos);
        nanos = 0L;
    }

    @SubscribeEvent
    public static void onDiagnostics(@Nonnull DiagnosticEvent event) {
        if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
            event.getRenderTimers().add(timer);
        }
    }
}

