/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.scripting.sets;

import javax.annotation.Nonnull;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.DayCycle;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.scripting.VariableSet;
import org.orecruncher.lib.scripting.sets.IDiurnalCycle;
import org.orecruncher.lib.scripting.sets.LazyVariable;

@OnlyIn(value=Dist.CLIENT)
public class DiurnalCycleVariables
extends VariableSet<IDiurnalCycle>
implements IDiurnalCycle {
    private final LazyVariable<Float> moonPhaseFactor = new LazyVariable<Float>(() -> Float.valueOf(GameUtils.isInGame() ? DayCycle.getMoonPhaseFactor((IWorld)GameUtils.getWorld()) : 0.0f));
    private final LazyVariable<Float> celestialAngle = new LazyVariable<Float>(() -> Float.valueOf(GameUtils.isInGame() ? GameUtils.getWorld().func_242415_f(0.0f) : 0.0f));
    private boolean isAuroraVisible;
    private boolean isDay;
    private boolean isNight;
    private boolean isSunrise;
    private boolean isSunset;

    public DiurnalCycleVariables() {
        super("diurnal");
    }

    @Override
    @Nonnull
    public IDiurnalCycle getInterface() {
        return this;
    }

    @Override
    public void update() {
        if (GameUtils.isInGame()) {
            DayCycle cycle = DayCycle.getCycle((IWorld)GameUtils.getWorld());
            this.isAuroraVisible = cycle.isAuroraVisible();
            this.isDay = cycle == DayCycle.DAYTIME;
            this.isNight = cycle == DayCycle.NIGHTTIME;
            this.isSunrise = cycle == DayCycle.SUNRISE;
            this.isSunset = cycle == DayCycle.SUNSET;
        } else {
            this.isAuroraVisible = false;
            this.isDay = false;
            this.isNight = false;
            this.isSunrise = false;
            this.isSunset = false;
        }
        this.moonPhaseFactor.reset();
        this.celestialAngle.reset();
    }

    @Override
    public boolean isDay() {
        return this.isDay;
    }

    @Override
    public boolean isNight() {
        return this.isNight;
    }

    @Override
    public boolean isSunrise() {
        return this.isSunrise;
    }

    @Override
    public boolean isSunset() {
        return this.isSunset;
    }

    @Override
    public boolean isAuroraVisible() {
        return this.isAuroraVisible;
    }

    @Override
    public float getMoonPhaseFactor() {
        return this.moonPhaseFactor.get().floatValue();
    }

    @Override
    public float getCelestialAngle() {
        return this.celestialAngle.get().floatValue();
    }
}

