/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.scripting.sets;

import javax.annotation.Nonnull;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.scripting.VariableSet;
import org.orecruncher.lib.scripting.sets.ISeasonVariables;
import org.orecruncher.lib.scripting.sets.LazyVariable;
import org.orecruncher.lib.seasons.Season;
import org.orecruncher.lib.seasons.SeasonType;

@OnlyIn(value=Dist.CLIENT)
public class SeasonVariables
extends VariableSet<ISeasonVariables>
implements ISeasonVariables {
    private final LazyVariable<Season> season = new LazyVariable<Season>(() -> Season.getSeason((World)GameUtils.getWorld()));
    private final LazyVariable<String> seasonName = new LazyVariable<String>(() -> this.season.get().getFormattedText());

    public SeasonVariables() {
        super("season");
    }

    @Override
    @Nonnull
    public ISeasonVariables getInterface() {
        return this;
    }

    @Override
    public void update() {
        this.season.reset();
        this.seasonName.reset();
    }

    @Override
    public boolean isSpring() {
        return this.season.get().getType() == SeasonType.SPRING;
    }

    @Override
    public boolean isSummer() {
        return this.season.get().getType() == SeasonType.SUMMER;
    }

    @Override
    public boolean isAutumn() {
        return this.season.get().getType() == SeasonType.AUTUMN;
    }

    @Override
    public boolean isWinter() {
        return this.season.get().getType() == SeasonType.WINTER;
    }

    @Override
    public String getSeason() {
        return this.seasonName.get();
    }
}

