/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.service;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import org.orecruncher.dsurround.DynamicSurroundings;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.Singleton;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.fml.ForgeUtils;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.lib.resource.ResourceUtils;
import org.orecruncher.lib.service.IModuleService;
import org.orecruncher.lib.tags.TagUtils;

@Mod.EventBusSubscriber(modid="dsurround", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ModuleServiceManager
implements ISelectiveResourceReloadListener {
    private static final IModLog LOGGER = DynamicSurroundings.LOGGER.createChild(ModuleServiceManager.class);
    private static final Singleton<ModuleServiceManager> instance = new Singleton<ModuleServiceManager>(ModuleServiceManager::new);
    private final ObjectArray<IModuleService> services = new ObjectArray();
    private boolean playerJoined = false;
    private boolean customTagsEventFired = false;
    private boolean vanillaTagsEventFired = false;
    private boolean reloadFired = false;

    private ModuleServiceManager() {
        IResourceManager resourceManager = GameUtils.getMC().func_195551_G();
        ((IReloadableResourceManager)resourceManager).func_219534_a((IFutureReloadListener)this);
    }

    public static ModuleServiceManager instance() {
        return instance.get();
    }

    public void add(@Nonnull IModuleService svc) {
        this.services.add(svc);
    }

    private void reload() {
        ForgeUtils.getEnabledResourcePacks().forEach(p -> {
            LOGGER.debug("Resource pack '%s'", p.func_195790_f());
            LOGGER.debug("+  %s", p.func_195789_b().getString());
            LOGGER.debug("+  %s", p.func_195795_c().getString());
        });
        this.performAction("reload", IModuleService::reload);
        this.services.forEach(IModuleService::log);
    }

    public void onResourceManagerReload(@Nonnull IResourceManager resourceManager, @Nonnull Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.SOUNDS)) {
            this.reportStatus("Received Resource reload callback");
            ResourceUtils.clearCache();
            this.reload();
        }
    }

    private boolean readyForReload() {
        return this.playerJoined && (this.vanillaTagsEventFired || this.customTagsEventFired);
    }

    private void reportStatus(@Nonnull String msg) {
        String txt = String.format("%s (playerJoined: %b, reloadFired: %b, customTagsEventFired: %b, vanillaTagsEventFired: %b)", msg, this.playerJoined, this.reloadFired, this.customTagsEventFired, this.vanillaTagsEventFired);
        LOGGER.info(txt, new Object[0]);
    }

    private void reloadIfReady() {
        if (!this.reloadFired && this.readyForReload()) {
            this.reloadFired = true;
            this.reload();
        }
    }

    private void clearReloadState() {
        this.reportStatus("Clearing reload state");
        this.playerJoined = false;
        this.reloadFired = false;
        this.customTagsEventFired = false;
        this.vanillaTagsEventFired = false;
    }

    @SubscribeEvent
    public static void entityJoinWorld(@Nonnull EntityJoinWorldEvent event) {
        PlayerEntity player = GameUtils.getPlayer();
        if (player != null && player.func_130014_f_().func_201670_d() && player.func_145782_y() == event.getEntity().func_145782_y()) {
            ModuleServiceManager.instance().joinWorld(event);
        }
    }

    private void joinWorld(@Nonnull EntityJoinWorldEvent ignore) {
        this.playerJoined = true;
        this.reportStatus("EntityJoinWorldEvent fired");
        this.reloadIfReady();
    }

    @SubscribeEvent
    public static void onLoad(@Nonnull TagsUpdatedEvent.VanillaTagTypes event) {
        ModuleServiceManager.instance().load(event);
    }

    private void load(@Nonnull TagsUpdatedEvent.VanillaTagTypes event) {
        this.vanillaTagsEventFired = true;
        TagUtils.setTagManager(event.getTagManager());
        this.reportStatus("TagsUpdatedEvent.VanillaTagTypes fired");
        this.reloadIfReady();
    }

    @SubscribeEvent
    public static void load(@Nonnull TagsUpdatedEvent.CustomTagTypes event) {
        ModuleServiceManager.instance().onLoad(event);
    }

    private void onLoad(@Nonnull TagsUpdatedEvent.CustomTagTypes event) {
        this.customTagsEventFired = true;
        TagUtils.setTagManager(event.getTagManager());
        this.reportStatus("TagsUpdatedEvent.CustomTagTypes fired");
        this.reloadIfReady();
    }

    @SubscribeEvent
    public static void onStop(@Nonnull ClientPlayerNetworkEvent.LoggedOutEvent event) {
        ModuleServiceManager.instance().stop();
    }

    private void stop() {
        this.performAction("stop", IModuleService::stop);
        TagUtils.clearTagManager();
        this.clearReloadState();
    }

    private void performAction(@Nonnull String actionName, @Nonnull Consumer<IModuleService> action) {
        LOGGER.info("Starting action '%s'", actionName);
        long start = System.nanoTime();
        List<String> results = this.services.stream().map(svc -> {
            long begin = System.nanoTime();
            action.accept((IModuleService)svc);
            long duration = System.nanoTime() - begin;
            return String.format("Action '%s::%s' took %dmsecs", svc.name(), actionName, (long)((double)duration / 1000000.0));
        }).collect(Collectors.toList());
        long duration = System.nanoTime() - start;
        results.forEach(x$0 -> LOGGER.debug((String)x$0, new Object[0]));
        LOGGER.info("Overall Action '%s' took %dmsecs", actionName, (long)((double)duration / 1000000.0));
    }
}

