/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.validation;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.orecruncher.lib.validation.IValidator;
import org.orecruncher.lib.validation.ValidationException;

public class Validators {
    private static final Reference2ObjectMap<Type, IValidator<?>> registeredValidators = new Reference2ObjectOpenHashMap();

    public static void registerValidator(@Nonnull Type type, @Nonnull IValidator<?> validator) {
        registeredValidators.put((Object)type, validator);
    }

    public static <T> void validate(@Nonnull T obj) throws ValidationException {
        Validators.validate(obj, (Consumer<String>)null);
    }

    public static <T> void validate(@Nonnull T obj, @Nullable Consumer<String> errorLogging) throws ValidationException {
        try {
            if (obj instanceof IValidator) {
                IValidator v = (IValidator)obj;
                v.validate(obj);
            }
        }
        catch (ValidationException ex) {
            if (errorLogging != null) {
                errorLogging.accept(ex.getMessage());
            }
            throw ex;
        }
    }

    public static <T> void validate(@Nonnull T obj, @Nullable Type type) throws ValidationException {
        Validators.validate(obj, type, null);
    }

    public static <T> void validate(@Nonnull T obj, @Nullable Type type, @Nullable Consumer<String> errorLogging) throws ValidationException {
        try {
            if (obj instanceof IValidator) {
                IValidator v = (IValidator)obj;
                v.validate(obj);
            } else {
                IValidator validator = (IValidator)registeredValidators.get((Object)type);
                if (validator != null) {
                    validator.validate(obj);
                }
            }
        }
        catch (ValidationException ex) {
            if (errorLogging != null) {
                errorLogging.accept(ex.getMessage());
            }
            throw ex;
        }
    }
}

