/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.effects;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.mobeffects.library.EffectLibrary;
import org.orecruncher.sndctrl.api.effects.AbstractEntityEffect;
import org.orecruncher.sndctrl.api.effects.IEntityEffectFactoryHandler;

@OnlyIn(value=Dist.CLIENT)
public class FactoryHandler
implements IEntityEffectFactoryHandler {
    private final ResourceLocation name;
    private final Function<LivingEntity, AbstractEntityEffect> factory;

    public FactoryHandler(@Nonnull ResourceLocation res, @Nonnull Function<LivingEntity, AbstractEntityEffect> factory) {
        this.name = res;
        this.factory = factory;
    }

    @Override
    @Nonnull
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public boolean appliesTo(@Nonnull LivingEntity entity) {
        return EffectLibrary.hasEffect((Entity)entity, this.getName());
    }

    @Override
    @Nonnull
    public AbstractEntityEffect get(@Nonnull LivingEntity entity) {
        return this.factory.apply(entity);
    }
}

