/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.effects;

import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.mobeffects.effects.FactoryHandler;
import org.orecruncher.mobeffects.library.ItemData;
import org.orecruncher.mobeffects.library.ItemLibrary;
import org.orecruncher.sndctrl.api.effects.AbstractEntityEffect;
import org.orecruncher.sndctrl.api.effects.IEntityEffectManager;

@OnlyIn(value=Dist.CLIENT)
public class PlayerToolbarEffect
extends AbstractEntityEffect {
    private static final ResourceLocation NAME = new ResourceLocation("mobeffects", "toolbar");
    public static final FactoryHandler FACTORY = new FactoryHandler(NAME, entity -> new PlayerToolbarEffect());
    protected MainHandTracker mainHand;
    protected HandTracker offHand;

    public PlayerToolbarEffect() {
        super(NAME);
    }

    @Override
    public void intitialize(@Nonnull IEntityEffectManager manager) {
        super.intitialize(manager);
        PlayerEntity player = (PlayerEntity)this.getEntity();
        this.mainHand = new MainHandTracker(manager, player);
        this.offHand = new HandTracker(manager, player);
    }

    @Override
    public void update() {
        PlayerEntity player = (PlayerEntity)this.getEntity();
        this.mainHand.update(player);
        this.offHand.update(player);
    }

    protected static class MainHandTracker
    extends HandTracker {
        protected int lastSlot;

        public MainHandTracker(@Nonnull IEntityEffectManager manager, @Nonnull PlayerEntity player) {
            super(manager, player, Hand.MAIN_HAND);
            this.lastSlot = player.field_71071_by.field_70461_c;
        }

        @Override
        protected boolean triggerNewEquipSound(@Nonnull PlayerEntity player) {
            return this.lastSlot != player.field_71071_by.field_70461_c || super.triggerNewEquipSound(player);
        }

        @Override
        public void update(@Nonnull PlayerEntity player) {
            super.update(player);
            this.lastSlot = player.field_71071_by.field_70461_c;
        }
    }

    protected static class HandTracker {
        protected final IEntityEffectManager manager;
        protected final Hand hand;
        protected Item lastHeld;

        protected HandTracker(@Nonnull IEntityEffectManager manager, @Nonnull PlayerEntity player) {
            this(manager, player, Hand.OFF_HAND);
        }

        protected HandTracker(@Nonnull IEntityEffectManager manager, @Nonnull PlayerEntity player, @Nonnull Hand hand) {
            this.manager = manager;
            this.hand = hand;
            this.lastHeld = this.getItemForHand(player, hand);
        }

        protected Item getItemForHand(PlayerEntity player, Hand hand) {
            ItemStack stack = player.func_184586_b(hand);
            return stack.func_77973_b();
        }

        protected boolean triggerNewEquipSound(@Nonnull PlayerEntity player) {
            Item heldItem = this.getItemForHand(player, this.hand);
            return heldItem != this.lastHeld;
        }

        public void update(@Nonnull PlayerEntity player) {
            if (this.triggerNewEquipSound(player)) {
                ItemStack currentStack = player.func_184586_b(this.hand);
                if (!currentStack.func_190926_b()) {
                    ItemData data = ItemLibrary.getItemData(currentStack);
                    if (this.manager.isActivePlayer((LivingEntity)player)) {
                        data.playEquipSound();
                    } else {
                        data.playEquipSound(player.func_233580_cy_());
                    }
                }
                this.lastHeld = currentStack.func_77973_b();
            }
        }
    }
}

