/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.footsteps;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.mobeffects.footsteps.facade.FacadeHelper;
import org.orecruncher.mobeffects.library.FootstepLibrary;

@OnlyIn(value=Dist.CLIENT)
public final class FootStrikeLocation {
    private final LivingEntity entity;
    private final Vector3d strike;
    private final BlockPos stepPos;

    public FootStrikeLocation(@Nonnull LivingEntity entity, double x, double y, double z) {
        this(entity, new Vector3d(x, y, z));
    }

    public FootStrikeLocation(@Nonnull LivingEntity entity, @Nonnull Vector3d loc) {
        this.entity = entity;
        this.strike = loc;
        this.stepPos = new BlockPos(loc);
    }

    protected FootStrikeLocation(@Nonnull LivingEntity entity, @Nonnull Vector3d loc, @Nonnull BlockPos pos) {
        this.entity = entity;
        this.strike = loc;
        this.stepPos = pos;
    }

    public FootStrikeLocation rebase(@Nonnull BlockPos pos) {
        if (!this.stepPos.equals((Object)pos)) {
            return new FootStrikeLocation(this.entity, this.strike, pos);
        }
        return this;
    }

    @Nonnull
    public LivingEntity getEntity() {
        return this.entity;
    }

    @Nonnull
    public BlockPos getStepPos() {
        return this.stepPos;
    }

    @Nonnull
    public Vector3d getStrikePosition() {
        return this.strike;
    }

    public Vector3d north() {
        return this.offset(Direction.NORTH, 1.0f);
    }

    public Vector3d south() {
        return this.offset(Direction.SOUTH, 1.0f);
    }

    public Vector3d east() {
        return this.offset(Direction.EAST, 1.0f);
    }

    public Vector3d west() {
        return this.offset(Direction.WEST, 1.0f);
    }

    public Vector3d up() {
        return this.offset(Direction.UP, 1.0f);
    }

    public Vector3d down() {
        return this.offset(Direction.DOWN, 1.0f);
    }

    @Nonnull
    public Vector3d offset(@Nonnull Direction facing, float n) {
        return n == 0.0f ? this.strike : new Vector3d(this.strike.field_72450_a + (double)((float)facing.func_82601_c() * n), this.strike.field_72448_b + (double)((float)facing.func_96559_d() * n), this.strike.field_72449_c + (double)((float)facing.func_82599_e() * n));
    }

    @Nullable
    protected Vector3d footprintPosition() {
        World world = this.entity.func_130014_f_();
        BlockState state = world.func_180495_p(this.stepPos);
        if (state.func_185904_a() == Material.field_151579_a) {
            return null;
        }
        BlockPos feetPos = this.stepPos.func_177984_a();
        BlockState upState = world.func_180495_p(feetPos);
        if (upState.func_185904_a() != Material.field_151579_a) {
            state = upState;
        } else {
            feetPos = this.stepPos;
        }
        if (!this.hasFootstepImprint(state, feetPos)) {
            return null;
        }
        VoxelShape shape = state.func_196952_d((IBlockReader)world, feetPos);
        double boundingY = state.func_196954_c((IBlockReader)world, feetPos).func_197758_c(Direction.Axis.Y);
        double collisionY = shape.func_197766_b() ? 0.0 : shape.func_197758_c(Direction.Axis.Y);
        double maxYblock = (double)feetPos.func_177956_o() + Math.max(boundingY, collisionY);
        return new Vector3d(this.strike.func_82615_a(), maxYblock, this.strike.func_82616_c());
    }

    protected boolean hasFootstepImprint(@Nonnull BlockState state, @Nonnull BlockPos pos) {
        BlockState footstepState = FacadeHelper.resolveState(this.entity, state, (IWorldReader)this.entity.func_130014_f_(), Vector3d.func_237489_a_((Vector3i)pos), Direction.UP);
        return FootstepLibrary.hasFootprint(footstepState);
    }
}

