/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.LocatableSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.SoundState;
import org.orecruncher.sndctrl.audio.handlers.SoundVolumeEvaluator;

@OnlyIn(value=Dist.CLIENT)
public class SoundInstance
extends LocatableSound
implements ISoundInstance {
    private SoundState state = SoundState.NONE;
    private final ISoundCategory category;
    private int playDelay;

    public SoundInstance(@Nonnull SoundEvent event, @Nonnull ISoundCategory cat) {
        this(event.func_187503_a(), cat);
    }

    public SoundInstance(@Nonnull ResourceLocation soundResource, @Nonnull ISoundCategory cat) {
        super(soundResource, cat.getRealCategory());
        this.category = cat;
        this.field_147662_b = 1.0f;
        this.field_147663_c = 1.0f;
        this.field_147658_f = 0.0;
        this.field_147661_e = 0.0;
        this.field_147660_d = 0.0;
        this.field_147659_g = false;
        this.field_147665_h = 0;
        this.field_147666_i = ISound.AttenuationType.LINEAR;
        this.playDelay = 0;
        this.field_184367_a = SoundHandler.field_147700_a;
        this.func_184366_a(GameUtils.getSoundHander());
    }

    @Override
    @Nonnull
    public ISoundCategory getSoundCategory() {
        return this.category;
    }

    @Override
    @Nonnull
    public SoundState getState() {
        return this.state;
    }

    @Override
    public void setState(@Nonnull SoundState state) {
        this.state = state;
    }

    public void setPitch(float p) {
        this.field_147663_c = p;
    }

    public void setPosition(float x, float y, float z) {
        this.field_147660_d = x;
        this.field_147661_e = y;
        this.field_147658_f = z;
    }

    public void setPosition(@Nonnull Vector3i pos) {
        this.setPosition((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
    }

    public void setPosition(@Nonnull Vector3d pos) {
        this.setPosition((float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c);
    }

    public void setAttenuationType(@Nonnull ISound.AttenuationType type) {
        this.field_147666_i = type;
    }

    public void setRepeat(boolean flag) {
        this.field_147659_g = flag;
    }

    public void setRepeatDelay(int delay) {
        this.field_147665_h = delay;
    }

    public void setVolume(float v) {
        this.field_147662_b = v;
    }

    @Override
    public void scaleVolume(float v) {
        this.field_147662_b *= v;
    }

    public void setGlobal(boolean flag) {
        this.field_217862_m = flag;
    }

    public boolean isDonePlaying() {
        return this.getState().isTerminal();
    }

    @Override
    public int getPlayDelay() {
        return this.playDelay;
    }

    @Override
    public void setPlayDelay(int delay) {
        this.playDelay = delay;
    }

    @Nonnull
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.func_147650_b().toString()).addValue((Object)this.getSoundCategory().toString()).addValue((Object)this.func_147656_j().toString()).addValue((Object)this.getState().toString()).add("v", this.func_147653_e()).add("ev", SoundInstance.getEffectiveVolume(this)).add("p", this.func_147655_f()).add("x", this.func_147649_g()).add("y", this.func_147654_h()).add("z", this.func_147651_i()).toString();
    }

    static float getEffectiveVolume(@Nonnull ISound sound) {
        try {
            return SoundVolumeEvaluator.getClampedVolume(sound);
        }
        catch (Throwable throwable) {
            return -1.0f;
        }
    }
}

