/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ChannelManager;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.Listener;
import net.minecraft.client.audio.SoundEngine;
import net.minecraft.client.audio.SoundSystem;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.SOFTHRTF;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.compat.ModEnvironment;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.sndctrl.SoundControl;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.handlers.SoundFXProcessor;
import org.orecruncher.sndctrl.config.Config;

@OnlyIn(value=Dist.CLIENT)
public final class SoundUtils {
    private static final IModLog LOGGER = SoundControl.LOGGER.createChild(SoundUtils.class);
    private static final String[] HRTF_STATUS = new String[]{"ALC_HRTF_DISABLED_SOFT", "ALC_HRTF_ENABLED_SOFT", "ALC_HRTF_DENIED_SOFT", "ALC_HRTF_REQUIRED_SOFT", "ALC_HRTF_HEADPHONES_DETECTED_SOFT", "ALC_HRTF_UNSUPPORTED_FORMAT_SOFT"};
    private static int MAX_SOUNDS = 0;
    private static int SOUND_LIMIT = 255;
    private static final Map<String, SoundCategory> categoryMapper = new Object2ObjectOpenHashMap();
    private static final Map<ISound, ChannelManager.Entry> playing;
    private static final Map<ISound, Integer> delayed;
    private static final Listener listener;
    private static final String COMPAT_FAILURE_MESSAGE = "===============================================================================================\n%s is installed and can cause conflicts with Dynamic Surroundings.\nDynamic Surroundings enhanced sound processing will be disabled.\n===============================================================================================";

    private SoundUtils() {
    }

    public static int getMaxSounds() {
        return MAX_SOUNDS;
    }

    public static boolean hasRoom() {
        return SoundUtils.getTotalPlaying() < SOUND_LIMIT;
    }

    static int getTotalPlaying() {
        return playing.size() + delayed.size();
    }

    @Nonnull
    static Map<ISound, ChannelManager.Entry> getPlayingSounds() {
        return playing;
    }

    @Nonnull
    static Map<ISound, Integer> getDelayedSounds() {
        return delayed;
    }

    @Nullable
    public static SoundCategory getSoundCategory(@Nonnull String name) {
        return categoryMapper.get(Objects.requireNonNull(name));
    }

    public static float getMasterGain() {
        return listener.func_216467_a();
    }

    public static boolean isSoundVolumeBlocked(@Nonnull ISound sound) {
        Objects.requireNonNull(sound);
        return SoundUtils.getMasterGain() <= 0.0f || !sound.func_211503_n() && sound.func_147653_e() <= 0.0f;
    }

    public static boolean inRange(@Nonnull Vector3d listener, @Nonnull ISound sound, int pad) {
        if (sound.func_217861_m() || sound.func_147656_j() == ISound.AttenuationType.NONE) {
            return true;
        }
        int distSq = sound.func_184364_b().func_206255_j() + pad;
        distSq *= distSq;
        return listener.func_186679_c(sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i()) < (double)distSq;
    }

    public static boolean inRange(@Nonnull Vector3d listener, @Nonnull ISound sound) {
        return SoundUtils.inRange(listener, sound, 0);
    }

    @Nonnull
    public static String debugString(@Nullable ISound sound) {
        if (sound == null) {
            return "null";
        }
        if (sound instanceof ISoundInstance) {
            return sound.toString();
        }
        return MoreObjects.toStringHelper((Object)sound).addValue((Object)sound.func_147650_b().toString()).addValue((Object)sound.func_184365_d().toString()).addValue((Object)sound.func_147656_j().toString()).add("v", sound.func_147653_e()).add("p", sound.func_147655_f()).add("x", sound.func_147649_g()).add("y", sound.func_147654_h()).add("z", sound.func_147651_i()).add("distance", sound.func_184364_b().func_206255_j()).add("streaming", sound.func_184364_b().func_188723_h()).add("global", sound.func_217861_m()).toString();
    }

    public static void initialize(@Nonnull SoundSystem soundSystem) {
        try {
            long device = soundSystem.field_216411_b;
            boolean hasFX = false;
            if (SoundUtils.doEnhancedSounds()) {
                LOGGER.info("Enhanced sounds are enabled.  Will perform sound engine reconfiguration.", new Object[0]);
                ALCCapabilities deviceCaps = ALC.createCapabilities((long)device);
                hasFX = deviceCaps.ALC_EXT_EFX;
                if (!hasFX) {
                    LOGGER.warn("EFX audio extensions not available for the current sound device!", new Object[0]);
                } else {
                    int[] attributes = new int[]{131075, 4, 0};
                    long ctx = ALC10.alcCreateContext((long)device, (int[])attributes);
                    ALC10.alcMakeContextCurrent((long)ctx);
                    AL10.alEnable((int)512);
                    if (deviceCaps.ALC_SOFT_HRTF) {
                        int status = ALC10.alcGetInteger((long)device, (int)6547);
                        LOGGER.info("HRTF status report before configuration: %s", HRTF_STATUS[status]);
                        if (status == 0 && ((Boolean)Config.CLIENT.sound.enableHRTF.get()).booleanValue()) {
                            boolean result = SOFTHRTF.alcResetDeviceSOFT((long)device, (int[])new int[]{6546, 1, 0});
                            if (result) {
                                status = ALC10.alcGetInteger((long)device, (int)6547);
                                LOGGER.warn("After configuration OpenAL reports HRTF status %s", HRTF_STATUS[status]);
                            } else {
                                LOGGER.warn("Unable to set HRTF feature in OpenAL", new Object[0]);
                            }
                        } else {
                            LOGGER.info("HRTF is already configured or Dynamic Surroundings is not configured to enable", new Object[0]);
                        }
                    }
                }
            }
            MAX_SOUNDS = ALC11.alcGetInteger((long)device, (int)4112);
            SOUND_LIMIT = MAX_SOUNDS - 10;
            if (hasFX) {
                SoundFXProcessor.initialize();
            }
            String vendor = AL10.alGetString((int)45057);
            String version = AL10.alGetString((int)45058);
            String renderer = AL10.alGetString((int)45059);
            String extensions = AL10.alGetString((int)45060);
            LOGGER.info("Vendor: %s", vendor);
            LOGGER.info("Version: %s", version);
            LOGGER.info("Renderer: %s", renderer);
            LOGGER.info("Extensions: %s", extensions);
        }
        catch (Throwable t) {
            LOGGER.warn(t.getMessage(), new Object[0]);
            LOGGER.warn("OpenAL special effects for sounds will not be available", new Object[0]);
        }
    }

    private static boolean doEnhancedSounds() {
        if (ModEnvironment.SoundFilters.isLoaded()) {
            LOGGER.warn(COMPAT_FAILURE_MESSAGE, "Sound Filters");
            return false;
        }
        if (ModEnvironment.SoundPhysics.isLoaded()) {
            LOGGER.warn(COMPAT_FAILURE_MESSAGE, "SoundPhysics");
            return false;
        }
        if (!((Boolean)Config.CLIENT.sound.enableEnhancedSounds.get()).booleanValue()) {
            LOGGER.warn("Enhanced sounds are not enabled.  No fancy sounds for you!", new Object[0]);
            return false;
        }
        return true;
    }

    public static void deinitialize(@Nonnull SoundSystem soundSystem) {
        SoundFXProcessor.deinitialize();
    }

    static {
        for (SoundCategory sc : SoundCategory.values()) {
            categoryMapper.put(sc.func_187948_a(), sc);
        }
        SoundEngine engine = GameUtils.getSoundHander().field_147694_f;
        playing = engine.field_217942_m;
        delayed = engine.field_148626_m;
        listener = engine.field_217938_h;
    }
}

