/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.Slider;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.fml.ForgeUtils;
import org.orecruncher.lib.gui.ColorPalette;
import org.orecruncher.lib.gui.GuiHelpers;
import org.orecruncher.sndctrl.api.sound.Category;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.api.sound.SoundBuilder;
import org.orecruncher.sndctrl.audio.AudioEngine;
import org.orecruncher.sndctrl.audio.SoundMetadata;
import org.orecruncher.sndctrl.library.IndividualSoundConfig;
import org.orecruncher.sndctrl.library.SoundLibrary;

@OnlyIn(value=Dist.CLIENT)
public class IndividualSoundControlListEntry
extends AbstractOptionList.Entry<IndividualSoundControlListEntry>
implements Slider.ISlider,
AutoCloseable {
    private static final int SLIDER_WIDTH = 100;
    private static final int BUTTON_WIDTH = 60;
    private static final int TOOLTIP_WIDTH = 300;
    private static final Button.IPressable NULL_PRESSABLE = b -> {};
    private static final ITextComponent CULL_ON = new TranslationTextComponent("sndctrl.text.soundconfig.cull");
    private static final ITextComponent CULL_OFF = new TranslationTextComponent("sndctrl.text.soundconfig.nocull");
    private static final ITextComponent BLOCK_ON = new TranslationTextComponent("sndctrl.text.soundconfig.block");
    private static final ITextComponent BLOCK_OFF = new TranslationTextComponent("sndctrl.text.soundconfig.noblock");
    private static final ITextComponent PLAY = new TranslationTextComponent("sndctrl.text.soundconfig.play");
    private static final ITextComponent STOP = new TranslationTextComponent("sndctrl.text.soundconfig.stop");
    private static final ITextComponent VANILLA_CREDIT = new TranslationTextComponent("sndctrl.text.tooltip.vanilla");
    private static final ITextComponent SLIDER_SUFFIX = new StringTextComponent("%");
    private static final TextFormatting[] CODING = new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.AQUA};
    private static final Collection<ITextComponent> VOLUME_HELP = GuiHelpers.getTrimmedTextCollection("sndctrl.text.soundconfig.volume.help", 300, CODING);
    private static final Collection<ITextComponent> PLAY_HELP = GuiHelpers.getTrimmedTextCollection("sndctrl.text.soundconfig.play.help", 300, CODING);
    private static final Collection<ITextComponent> CULL_HELP = GuiHelpers.getTrimmedTextCollection("sndctrl.text.soundconfig.cull.help", 300, CODING);
    private static final Collection<ITextComponent> BLOCK_HELP = GuiHelpers.getTrimmedTextCollection("sndctrl.text.soundconfig.block.help", 300, CODING);
    private static final int CONTROL_SPACING = 3;
    private final IndividualSoundConfig config;
    private final Slider volume;
    private final Button blockButton;
    private final Button cullButton;
    private final Button playButton;
    private final List<Widget> children = new ArrayList<Widget>();
    private List<ITextComponent> defaultTooltip;
    private ISoundInstance soundPlay;

    public IndividualSoundControlListEntry(@Nonnull IndividualSoundConfig data, boolean enablePlay) {
        this.config = data;
        this.volume = new Slider(0, 0, 100, 0, StringTextComponent.field_240750_d_, SLIDER_SUFFIX, 0.0, 400.0, (double)this.config.getVolumeScaleInt(), false, true, NULL_PRESSABLE, (Slider.ISlider)this);
        this.children.add((Widget)this.volume);
        this.blockButton = new Button(0, 0, 60, 0, this.config.isBlocked() ? BLOCK_ON : BLOCK_OFF, this::toggleBlock);
        this.children.add((Widget)this.blockButton);
        this.cullButton = new Button(0, 0, 60, 0, this.config.isCulled() ? CULL_ON : CULL_OFF, this::toggleCull);
        this.children.add((Widget)this.cullButton);
        this.playButton = new Button(0, 0, 60, 0, PLAY, this::play){

            public void func_230988_a_(@Nonnull SoundHandler ignore) {
            }
        };
        this.playButton.field_230693_o_ = enablePlay;
        this.children.add((Widget)this.playButton);
    }

    @Nonnull
    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.children;
    }

    public void func_230432_a_(@Nonnull MatrixStack matrixStack, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean mouseOver, float partialTick_) {
        FontRenderer font = GameUtils.getMC().field_71466_p;
        float f = rowTop;
        font.getClass();
        float labelY = f + (float)(rowHeight - 9) / 2.0f;
        String text = this.config.getLocation().toString();
        font.func_238421_b_(matrixStack, text, (float)rowLeft, labelY, ColorPalette.WHITE.rgb());
        int rightMargin = rowLeft + rowWidth;
        this.volume.field_230690_l_ = rightMargin - this.volume.func_230998_h_();
        this.volume.field_230691_m_ = rowTop;
        this.volume.setHeight(rowHeight);
        this.playButton.field_230690_l_ = (rightMargin -= this.volume.func_230998_h_() + 3) - this.playButton.func_230998_h_();
        this.playButton.field_230691_m_ = rowTop;
        this.playButton.setHeight(rowHeight);
        this.blockButton.field_230690_l_ = (rightMargin -= this.playButton.func_230998_h_() + 3) - this.blockButton.func_230998_h_();
        this.blockButton.field_230691_m_ = rowTop;
        this.blockButton.setHeight(rowHeight);
        this.cullButton.field_230690_l_ = (rightMargin -= this.blockButton.func_230998_h_() + 3) - this.cullButton.func_230998_h_();
        this.cullButton.setHeight(rowHeight);
        this.cullButton.field_230691_m_ = rowTop;
        for (Widget w : this.children) {
            w.func_230430_a_(matrixStack, mouseX, mouseY, partialTick_);
        }
    }

    protected void toggleBlock(@Nonnull Button button) {
        this.config.setIsBlocked(!this.config.isBlocked());
        button.func_238482_a_(this.config.isBlocked() ? BLOCK_ON : BLOCK_OFF);
    }

    protected void toggleCull(@Nonnull Button button) {
        this.config.setIsCulled(!this.config.isCulled());
        button.func_238482_a_(this.config.isCulled() ? CULL_ON : CULL_OFF);
    }

    public void onChangeSliderValue(@Nonnull Slider slider) {
        this.config.setVolumeScaleInt(slider.getValueInt());
    }

    protected void play(@Nonnull Button button) {
        if (this.soundPlay == null) {
            Optional<SoundEvent> event = SoundLibrary.getSound(this.config.getLocation());
            event.ifPresent(se -> {
                this.soundPlay = SoundBuilder.builder(se, Category.CONFIG).setGlobal(true).setVolume(this.config.getVolumeScale()).build();
                AudioEngine.play(this.soundPlay);
                this.playButton.func_238482_a_(STOP);
            });
        } else {
            AudioEngine.stop(this.soundPlay);
            this.soundPlay = null;
            this.playButton.func_238482_a_(PLAY);
        }
    }

    @Override
    public void close() {
        if (this.soundPlay != null) {
            AudioEngine.stop(this.soundPlay);
            this.soundPlay = null;
        }
    }

    public void tick() {
        if (this.soundPlay != null && this.soundPlay.getState().isTerminal()) {
            this.soundPlay = null;
            this.playButton.func_238482_a_(PLAY);
        }
    }

    @Nonnull
    protected List<ITextComponent> getToolTip(int mouseX, int mouseY) {
        if (this.defaultTooltip == null) {
            ISoundCategory category;
            this.defaultTooltip = new ArrayList<ITextComponent>();
            ResourceLocation loc = this.config.getLocation();
            String modName = ForgeUtils.getModDisplayName(loc.func_110624_b());
            this.defaultTooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + modName));
            this.defaultTooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + loc.toString()));
            SoundMetadata meta = SoundLibrary.getSoundMetadata(loc);
            ITextComponent title = meta.getTitle();
            if (title != StringTextComponent.field_240750_d_) {
                this.defaultTooltip.add(title);
            }
            if ((category = meta.getCategory()) != Category.NEUTRAL) {
                this.defaultTooltip.add((ITextComponent)new TranslationTextComponent("sndctrl.text.tooltip.category").func_230529_a_(category.getTextComponent()));
            }
            if (modName.equals("Minecraft")) {
                this.defaultTooltip.add(VANILLA_CREDIT);
            } else {
                this.defaultTooltip.addAll(meta.getCredits());
            }
        }
        ArrayList<ITextComponent> result = new ArrayList<ITextComponent>(this.defaultTooltip);
        if (this.volume.func_231047_b_((double)mouseX, (double)mouseY)) {
            result.addAll(VOLUME_HELP);
        } else if (this.blockButton.func_231047_b_((double)mouseX, (double)mouseY)) {
            result.addAll(BLOCK_HELP);
        } else if (this.cullButton.func_231047_b_((double)mouseX, (double)mouseY)) {
            result.addAll(CULL_HELP);
        } else if (this.playButton.func_231047_b_((double)mouseX, (double)mouseY)) {
            result.addAll(PLAY_HELP);
        }
        return result;
    }

    @Nonnull
    public IndividualSoundConfig getData() {
        return this.config;
    }
}

