/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.mixins;

import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.client.GameSettings;
import net.minecraft.client.audio.ChannelManager;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEngine;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundSource;
import net.minecraft.client.audio.SoundSystem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;
import org.orecruncher.sndctrl.SoundControl;
import org.orecruncher.sndctrl.api.sound.Category;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.AudioEngine;
import org.orecruncher.sndctrl.audio.SoundUtils;
import org.orecruncher.sndctrl.audio.handlers.SoundFXProcessor;
import org.orecruncher.sndctrl.audio.handlers.SoundVolumeEvaluator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={SoundEngine.class})
public class MixinSoundEngine {
    @Final
    @Shadow
    private SoundSystem field_217937_g;
    @Final
    @Shadow
    public Map<ISound, ChannelManager.Entry> field_217942_m;
    @Final
    @Shadow
    private GameSettings field_148619_d;
    @Final
    @Shadow
    private Map<ISound, Integer> field_148624_n;
    @Final
    @Shadow
    private Multimap<SoundCategory, ISound> field_217943_n;
    @Final
    @Shadow
    private List<ITickableSound> field_148625_l;

    @Inject(method={"getClampedVolume(Lnet/minecraft/client/audio/ISound;)F"}, at={@At(value="HEAD")}, cancellable=true)
    private void getClampedVolume(ISound sound, CallbackInfoReturnable<Float> ci) {
        try {
            ci.setReturnValue((Object)Float.valueOf(SoundVolumeEvaluator.getClampedVolume(sound)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Inject(method={"load()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/audio/SoundSystem;init()V", shift=At.Shift.AFTER)})
    public void initialize(CallbackInfo ci) {
        SoundUtils.initialize(this.field_217937_g);
    }

    @Inject(method={"unload()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/audio/SoundSystem;unload()V", shift=At.Shift.BEFORE)})
    public void deinitialize(CallbackInfo ci) {
        SoundUtils.deinitialize(this.field_217937_g);
    }

    @Inject(method={"play(Lnet/minecraft/client/audio/ISound;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/audio/ChannelManager$Entry;runOnSoundExecutor(Ljava/util/function/Consumer;)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    public void onSoundPlay(ISound p_sound, CallbackInfo ci, SoundEventAccessor soundeventaccessor, ResourceLocation resourcelocation, Sound sound, float f, float f1, SoundCategory soundcategory, float f2, float f3, ISound.AttenuationType attenuationtype, boolean flag, Vector3d vector3d, boolean flag2, boolean flag3, CompletableFuture completablefuture, ChannelManager.Entry entry) {
        try {
            SoundFXProcessor.onSoundPlay(p_sound, entry);
            AudioEngine.onPlaySound(p_sound);
        }
        catch (Throwable t) {
            SoundControl.LOGGER.error(t, "Error in onSoundPlay()!", new Object[0]);
        }
    }

    @Inject(method={"tick(Z)V"}, at={@At(value="RETURN")})
    public void tick(boolean isGamePaused, @Nonnull CallbackInfo ci) {
        if (!isGamePaused) {
            return;
        }
        Iterator<Map.Entry<ISound, ChannelManager.Entry>> iterator = this.field_217942_m.entrySet().iterator();
        while (iterator.hasNext()) {
            ISoundInstance instance;
            Map.Entry<ISound, ChannelManager.Entry> entry = iterator.next();
            if (!(entry.getKey() instanceof ISoundInstance) || (instance = (ISoundInstance)entry.getKey()).getSoundCategory() != Category.CONFIG) continue;
            ChannelManager.Entry channelmanager$entry1 = entry.getValue();
            float f2 = this.field_148619_d.func_186711_a(instance.func_184365_d());
            if (f2 <= 0.0f) {
                channelmanager$entry1.func_217888_a(SoundSource::func_216418_f);
                iterator.remove();
                continue;
            }
            if (!channelmanager$entry1.func_217889_a()) continue;
            iterator.remove();
            this.field_148624_n.remove(instance);
            try {
                this.field_217943_n.remove((Object)instance.func_184365_d(), (Object)instance);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (!(instance instanceof ITickableSound)) continue;
            this.field_148625_l.remove(instance);
        }
    }
}

