/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.clickable;

import com.mojang.blaze3d.matrix.MatrixStack;
import lehjr.numina.client.gui.clickable.Clickable;
import lehjr.numina.client.gui.gemoetry.DrawableTile;
import lehjr.numina.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.common.math.Colour;
import lehjr.numina.common.string.StringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class CheckBox
extends Clickable {
    protected boolean isChecked;
    protected DrawableTile tile;
    ITextComponent label;

    public CheckBox(MusePoint2D position, String displayString, boolean isChecked) {
        super(position);
        this.makeNewTile();
        this.label = new StringTextComponent(displayString);
        this.isChecked = isChecked;
        this.enableAndShow();
    }

    public CheckBox(MusePoint2D position, ITextComponent displayString, boolean isChecked) {
        super(position);
        this.makeNewTile();
        this.label = displayString;
        this.isChecked = isChecked;
        this.enableAndShow();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        if (this.isVisible()) {
            this.tile.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
            if (this.isChecked) {
                StringUtils.drawShadowedString(matrixStack, "x", this.tile.centerx() - 2.0, this.tile.centery() - 5.0, Colour.WHITE);
            }
            StringUtils.drawShadowedString(matrixStack, this.label, this.tile.centerx() + 8.0, this.tile.centery() - 4.0, Colour.WHITE);
        }
    }

    void makeNewTile() {
        if (this.tile == null) {
            MusePoint2D ul = this.getPosition().plus(4.0, 4.0);
            this.tile = new DrawableTile(ul, ul.plus(8.0, 8.0)).setBackgroundColour(Colour.BLACK).setTopBorderColour(Colour.DARK_GREY).setBottomBorderColour(Colour.DARK_GREY);
        }
    }

    @Override
    public boolean hitBox(double x, double y) {
        return this.isVisible() && this.isEnabled() ? this.tile.containsPoint(x, y) : false;
    }

    @Override
    public void setPosition(MusePoint2D position) {
        super.setPosition(position);
        if (this.tile == null) {
            this.makeNewTile();
        }
        this.tile.setPosition(position);
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean checked) {
        this.isChecked = checked;
    }

    @Override
    public void onPressed() {
        if (this.isVisible() && this.isEnabled()) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.isChecked = !this.isChecked;
        }
        super.onPressed();
    }
}

