/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.clickable;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import lehjr.numina.client.gui.clickable.IClickable;
import lehjr.numina.client.gui.gemoetry.DrawableTile;
import lehjr.numina.client.gui.gemoetry.IRect;
import lehjr.numina.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.common.math.Colour;
import lehjr.numina.common.math.MathUtils;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;

public class Slider
extends DrawableTile
implements IClickable {
    IClickable.IPressable onPressed;
    IClickable.IReleasable onReleased;
    protected boolean isVisible = true;
    protected boolean isEnabled = true;
    private boolean isCreatingNewRects = false;
    String id = "";
    protected boolean isHorizontal;
    protected double tickVal = 0.0;
    protected boolean showTickLines = false;
    public double internalVal = 0.0;
    protected final double thickness = 8.0;
    protected double size = 16.0;
    DrawableTile knobRect;
    public boolean dragging = false;
    @Nullable
    public ISlider parent = null;

    public Slider(MusePoint2D position, double size, String id) {
        this(position, true, size, id, 0.0);
    }

    public Slider(MusePoint2D position, boolean isHorizontal, double size, String id, double currentVal) {
        this(position, isHorizontal, size, id, currentVal, null);
    }

    public Slider(MusePoint2D position, boolean isHorizontal, double size, String id, double currentVal, @Nullable ISlider iSlider) {
        super(1.0, 1.0, 1.0, 1.0);
        this.isHorizontal = isHorizontal;
        this.size = size;
        this.id = id;
        this.parent = iSlider;
        this.setValue(currentVal);
        this.setPosition(position);
        this.createNewRects();
        this.calculateTickCoordinates();
    }

    public String id() {
        return this.id;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        if (this.isVisible()) {
            super.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
            if (this.isHorizontal) {
                this.knobRect.setPosition(new MusePoint2D(this.centerx() + this.size * (this.internalVal - 0.5), this.centery()));
            } else {
                this.knobRect.setPosition(new MusePoint2D(this.centerx(), this.centery() + this.size * (this.internalVal - 0.5)));
            }
            if (this.showTickLines && this.tickVal != 0.0) {
                if (this.isHorizontal) {
                    for (double val : this.calculateTickCoordinates()) {
                        this.drawSingleLine(matrixStack, val, this.top(), val, this.bottom(), Colour.WHITE);
                    }
                } else {
                    for (double val : this.calculateTickCoordinates()) {
                        this.drawSingleLine(matrixStack, this.left(), val, this.right(), val, Colour.WHITE);
                    }
                }
            }
            this.knobRect.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
        }
    }

    public void update(double mouseX, double mouseY) {
        double siderStart = this.internalVal;
        this.internalVal = this.isEnabled() && this.isVisible() && this.dragging ? (this.isHorizontal ? MathUtils.clampDouble((mouseX - this.centerx()) / (this.size - this.knobRect.finalWidth() * 0.5) + 0.5, 0.0, 1.0) : MathUtils.clampDouble((mouseY - this.centery()) / (this.size - this.knobRect.finalHeight() * 0.5) + 0.5, 0.0, 1.0)) : MathUtils.clampDouble(this.internalVal, 0.0, 1.0);
        this.setValue(this.getValue());
        if (siderStart != this.internalVal && this.parent != null) {
            this.parent.onChangeSliderValue(this);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (IClickable.super.mouseClicked(mouseX, mouseY, button)) {
            this.dragging = true;
            this.update(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.dragging) {
            this.update(mouseX, mouseY);
            this.dragging = false;
            return true;
        }
        return false;
    }

    public double getValue() {
        return this.internalVal;
    }

    public double getInternalVal() {
        return this.internalVal;
    }

    public void setValue(double value) {
        this.internalVal = MathUtils.clampDouble(value, 0.0, 1.0);
    }

    public void setValueByX(double value) {
        this.internalVal = this.isHorizontal ? MathUtils.clampDouble((value - this.centerx()) / this.width() + 0.5, 0.0, 1.0) : MathUtils.clampDouble((value - this.centery()) / this.size + 0.5, 0.0, 1.0);
    }

    void createNewRects() {
        this.isCreatingNewRects = true;
        if (this.isHorizontal) {
            super.setHeight(8.0);
            super.setWidth(this.size);
            this.knobRect = new DrawableTile(this.centerx() - 4.0, this.centery() - 1.0 - 4.0, this.centerx() + 4.0, this.centery() + 1.0 + 4.0);
        } else {
            super.setHeight(this.size);
            super.setWidth(8.0);
            this.knobRect = new DrawableTile(this.centerx() - 1.0 - 4.0, this.centery() - 4.0, this.centerx() + 1.0 + 4.0, this.centery() + 4.0);
        }
        this.knobRect.setBackgroundColour(Colour.LIGHT_GREY);
        this.knobRect.setBottomBorderColour(Colour.BLACK);
        this.knobRect.setTopBorderColour(Colour.WHITE);
        this.setBackgroundColour(Colour.DARK_GREY);
        this.setBottomBorderColour(Colour.WHITE);
        this.setTopBorderColour(Colour.BLACK);
        this.isCreatingNewRects = false;
    }

    List<Double> calculateTickCoordinates() {
        ArrayList<Double> vals = new ArrayList<Double>();
        if (this.tickVal != 0.0) {
            for (double i = this.getMinVal() + this.tickVal; i < this.getMaxValue(); i += this.tickVal) {
                vals.add((this.isHorizontal ? this.finalLeft() : this.finalTop()) + this.size * MathUtils.clampDouble((i - this.getMinVal()) / (this.getMaxValue() - this.getMinVal()), 0.0, 1.0));
            }
        }
        return vals;
    }

    public double getMinVal() {
        return 0.0;
    }

    public double getMaxValue() {
        return 1.0;
    }

    void drawSingleLine(MatrixStack matrixStack, double xStart, double yStart, double xEnd, double yEnd, Colour colour) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        this.preDraw(1, DefaultVertexFormats.field_181706_f);
        RenderSystem.lineWidth((float)1.0f);
        builder.func_227888_a_(matrix4f, (float)xStart, (float)yStart, this.getZLevel()).func_227885_a_(colour.r, colour.g, colour.b, colour.a).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)xEnd, (float)yEnd, this.getZLevel()).func_227885_a_(colour.r, colour.g, colour.b, colour.a).func_181675_d();
        this.drawTesselator();
        this.postDraw();
    }

    @Override
    public IRect setWH(MusePoint2D wh) {
        this.setHeight(wh.getY());
        this.setWidth(wh.getX());
        return this;
    }

    @Override
    public IRect setWidth(double value) {
        if (this.isHorizontal) {
            super.setWidth(value);
        }
        return this;
    }

    @Override
    public IRect setHeight(double value) {
        if (!this.isHorizontal) {
            super.setHeight(value);
        }
        return this;
    }

    @Override
    public boolean containsPoint(double x, double y) {
        return x > this.left() - 2.0 && x < this.right() + 2.0 && y > this.top() - 2.0 && y < this.bottom() + 2.0;
    }

    @Override
    public void setEnabled(boolean b) {
        this.isEnabled = b;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean b) {
        this.isVisible = b;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void doThisOnChange() {
        if (!this.isCreatingNewRects) {
            this.createNewRects();
        }
        super.doThisOnChange();
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }

    @Override
    public void onPressed() {
        if (this.isVisible() && this.isEnabled() && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }

    @Override
    public void onReleased() {
        if (this.isVisible() && this.isEnabled() && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }

    public static interface ISlider {
        public void onChangeSliderValue(Slider var1);
    }
}

