/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.gemoetry;

import lehjr.numina.client.gui.gemoetry.FlyFromPointToPoint2D;
import lehjr.numina.client.gui.gemoetry.IRect;
import lehjr.numina.client.gui.gemoetry.MusePoint2D;

public class RelativeRect
implements IRect {
    protected IRect rectBelowMe;
    protected IRect rectAboveMe;
    protected IRect rectLeftOfMe;
    protected IRect rectRightOfMe;
    MusePoint2D ul;
    MusePoint2D wh;
    final boolean growFromMiddle;
    IRect.IInit onInit;
    IRect.IDoThis iDoThis;

    public RelativeRect() {
        this(false);
    }

    public RelativeRect(boolean growFromMiddle) {
        this(0.0, 0.0, 0.0, 0.0, growFromMiddle);
    }

    public RelativeRect(MusePoint2D ul, MusePoint2D br) {
        this(ul, br, false);
    }

    public RelativeRect(MusePoint2D ul, MusePoint2D br, boolean growFromMiddle) {
        this.ul = ul;
        this.wh = br.minus(ul);
        this.growFromMiddle = growFromMiddle;
    }

    public RelativeRect(double left, double top, double right, double bottom) {
        this(left, top, right, bottom, false);
    }

    public RelativeRect(double left, double top, double right, double bottom, boolean growFromMiddle) {
        this.ul = new MusePoint2D(left, top);
        this.wh = new MusePoint2D(right - left, bottom - top);
        this.growFromMiddle = growFromMiddle;
    }

    @Override
    public RelativeRect init(double left, double top, double right, double bottom) {
        this.ul.setX(left);
        this.ul.setY(top);
        this.wh.setX(right - left);
        this.wh.setY(bottom - top);
        this.initGrowth();
        this.onInit();
        return this;
    }

    @Override
    public IRect setUL(MusePoint2D ul) {
        this.ul = ul;
        this.doThisOnChange();
        return this;
    }

    @Override
    public IRect setWH(MusePoint2D wh) {
        this.wh = wh;
        this.doThisOnChange();
        return this;
    }

    @Override
    public double top() {
        if (this.rectAboveMe != null) {
            return this.rectAboveMe.bottom();
        }
        return this.ul.getY();
    }

    @Override
    public double finalTop() {
        if (this.rectAboveMe != null) {
            return this.rectAboveMe.finalBottom();
        }
        if (this.ul instanceof FlyFromPointToPoint2D) {
            return ((FlyFromPointToPoint2D)this.ul).getFinalY();
        }
        return this.ul.getY();
    }

    @Override
    public double left() {
        if (this.rectLeftOfMe != null) {
            return this.rectLeftOfMe.right();
        }
        return this.ul.getX();
    }

    @Override
    public double finalLeft() {
        if (this.rectLeftOfMe != null) {
            return this.rectLeftOfMe.finalRight();
        }
        if (this.ul instanceof FlyFromPointToPoint2D) {
            return ((FlyFromPointToPoint2D)this.ul).getFinalX();
        }
        return this.ul.getX();
    }

    @Override
    public double right() {
        if (this.rectRightOfMe != null) {
            return this.rectRightOfMe.left();
        }
        return this.left() + this.wh.getX();
    }

    @Override
    public double finalRight() {
        if (this.rectRightOfMe != null) {
            return this.rectRightOfMe.finalLeft();
        }
        return this.finalLeft() + this.finalWidth();
    }

    @Override
    public double bottom() {
        if (this.rectBelowMe != null) {
            return this.rectBelowMe.top();
        }
        return this.top() + this.height();
    }

    @Override
    public double finalBottom() {
        if (this.rectBelowMe != null) {
            return this.rectBelowMe.top();
        }
        return this.finalTop() + this.finalHeight();
    }

    @Override
    public MusePoint2D getUL() {
        return this.ul;
    }

    @Override
    public MusePoint2D getWH() {
        return this.wh;
    }

    @Override
    public double width() {
        return this.wh.getX();
    }

    @Override
    public double finalWidth() {
        if (this.wh instanceof FlyFromPointToPoint2D) {
            return ((FlyFromPointToPoint2D)this.wh).getFinalX();
        }
        return this.wh.getX();
    }

    @Override
    public double height() {
        return this.wh.getY();
    }

    @Override
    public double finalHeight() {
        if (this.wh instanceof FlyFromPointToPoint2D) {
            return ((FlyFromPointToPoint2D)this.wh).getFinalY();
        }
        return this.wh.getY();
    }

    @Override
    public IRect setLeft(double value) {
        this.ul.setX(value);
        this.doThisOnChange();
        return this;
    }

    @Override
    public IRect setRight(double value) {
        this.setLeft(value - this.finalWidth());
        this.doThisOnChange();
        return this;
    }

    @Override
    public IRect setTop(double value) {
        this.ul.setY(value);
        this.doThisOnChange();
        return this;
    }

    @Override
    public IRect setBottom(double value) {
        this.setTop(value - this.finalHeight());
        this.doThisOnChange();
        return this;
    }

    @Override
    public IRect setWidth(double value) {
        this.wh.setX(value);
        this.doThisOnChange();
        return this;
    }

    @Override
    public IRect setHeight(double value) {
        this.wh.setY(value);
        this.doThisOnChange();
        return this;
    }

    @Override
    public void move(MusePoint2D moveAmount) {
        this.move(moveAmount.getX(), moveAmount.getY());
        this.doThisOnChange();
    }

    @Override
    public void move(double x, double y) {
        this.ul.setX(this.finalLeft() + x);
        this.ul.setY(this.finalTop() + y);
        this.doThisOnChange();
    }

    @Override
    public void setPosition(MusePoint2D positionIn) {
        if (!this.wh.equals(MusePoint2D.ZERO)) {
            this.setUL(positionIn.minus(this.finalWidth() * 0.5, this.finalHeight() * 0.5));
        } else {
            this.ul = positionIn;
        }
        this.doThisOnChange();
    }

    @Override
    public boolean growFromMiddle() {
        return this.growFromMiddle;
    }

    public RelativeRect copyOf() {
        return new RelativeRect(this.left(), this.top(), this.right(), this.bottom());
    }

    @Override
    public IRect setMeLeftOf(IRect otherRightOfMe) {
        this.rectRightOfMe = otherRightOfMe;
        this.doThisOnChange();
        return this;
    }

    @Override
    public IRect setMeRightOf(IRect otherLeftOfMe) {
        this.rectLeftOfMe = otherLeftOfMe;
        this.doThisOnChange();
        return this;
    }

    @Override
    public IRect setMeAbove(IRect otherBelowMe) {
        this.rectBelowMe = otherBelowMe;
        this.doThisOnChange();
        return this;
    }

    @Override
    public IRect setMeBelow(IRect otherAboveMe) {
        this.rectAboveMe = otherAboveMe;
        this.doThisOnChange();
        return this;
    }

    public RelativeRect getRect() {
        return this;
    }

    @Override
    public void setOnInit(IRect.IInit onInit) {
        this.onInit = onInit;
    }

    @Override
    public void onInit() {
        if (this.onInit != null) {
            this.onInit.onInit(this);
        }
    }

    @Override
    public void setDoThisOnChange(IRect.IDoThis iDoThis) {
        this.iDoThis = iDoThis;
    }

    @Override
    public void doThisOnChange() {
        if (this.iDoThis != null) {
            this.iDoThis.doThisOnChange(this);
        }
    }

    @Override
    public void initGrowth() {
        if (this.growFromMiddle()) {
            MusePoint2D center = this.ul.plus(this.wh.times(0.5));
            this.ul = new FlyFromPointToPoint2D(center, this.getUL(), 200.0);
            this.wh = new FlyFromPointToPoint2D(new MusePoint2D(0.0, 0.0), this.getWH(), 200.0);
        }
        this.doThisOnChange();
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(this.getClass()).append(":\n");
        stringbuilder.append("Center: ").append(this.center()).append("\n");
        stringbuilder.append("Left: ").append(this.left()).append("\n");
        stringbuilder.append("Final Left: ").append(this.finalLeft()).append("\n");
        stringbuilder.append("Right: ").append(this.right()).append("\n");
        stringbuilder.append("Final Right: ").append(this.finalRight()).append("\n");
        stringbuilder.append("Bottom: ").append(this.bottom()).append("\n");
        stringbuilder.append("Final Bottom: ").append(this.finalBottom()).append("\n");
        stringbuilder.append("Top: ").append(this.top()).append("\n");
        stringbuilder.append("Final Top: ").append(this.finalTop()).append("\n");
        stringbuilder.append("Width: ").append(this.width()).append("\n");
        stringbuilder.append("Final Width: ").append(this.finalWidth()).append("\n");
        stringbuilder.append("Height: ").append(this.height()).append("\n");
        stringbuilder.append("Final Height: ").append(this.finalHeight()).append("\n");
        return stringbuilder.toString();
    }
}

