/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.base;

import forge.NuminaOBJLoader;
import lehjr.numina.client.event.ArmorLayerSetup;
import lehjr.numina.client.event.FOVUpdateEventHandler;
import lehjr.numina.client.event.RenderEventHandler;
import lehjr.numina.client.event.ToolTipEvent;
import lehjr.numina.client.gui.GuiIcon;
import lehjr.numina.client.render.IconUtils;
import lehjr.numina.client.render.NuminaSpriteUploader;
import lehjr.numina.client.screen.ArmorStandScreen;
import lehjr.numina.client.screen.ChargingBaseScreen;
import lehjr.numina.common.base.NuminaObjects;
import lehjr.numina.common.capabilities.heat.HeatCapability;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.common.capabilities.player.CapabilityPlayerKeyStates;
import lehjr.numina.common.capabilities.render.ModelSpecNBTCapability;
import lehjr.numina.common.capabilities.render.chameleon.ChameleonCapability;
import lehjr.numina.common.capabilities.render.colour.ColourCapability;
import lehjr.numina.common.capabilities.render.highlight.HighLightCapability;
import lehjr.numina.common.config.ConfigHelper;
import lehjr.numina.common.config.NuminaSettings;
import lehjr.numina.common.entity.NuminaArmorStandEntity;
import lehjr.numina.common.event.EventBusHelper;
import lehjr.numina.common.event.LogoutEventHandler;
import lehjr.numina.common.event.PlayerUpdateHandler;
import lehjr.numina.common.integration.scannable.MPSGuiScanner;
import lehjr.numina.common.network.NuminaPackets;
import lehjr.numina.common.recipe.RecipeSerializersRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="numina")
public class Numina {
    public Numina() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, NuminaSettings.CLIENT_SPEC, ConfigHelper.setupConfigFile("numina-client-only.toml", "numina").getAbsolutePath());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, NuminaSettings.SERVER_SPEC);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        NuminaObjects.ITEMS.register(modEventBus);
        NuminaObjects.BLOCKS.register(modEventBus);
        NuminaObjects.TILE_TYPES.register(modEventBus);
        NuminaObjects.ENTITY_TYPES.register(modEventBus);
        NuminaObjects.CONTAINER_TYPES.register(modEventBus);
        RecipeSerializersRegistry.RECIPE_SERIALIZERS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)new LogoutEventHandler());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Numina.clientStart(modEventBus));
        modEventBus.addListener(event -> {
            new RuntimeException("Got config " + event.getConfig() + " name " + event.getConfig().getModId() + ":" + event.getConfig().getFileName());
            ModConfig config = event.getConfig();
            if (config.getSpec() == NuminaSettings.SERVER_SPEC) {
                NuminaSettings.getModuleConfig().setServerConfig(config);
            }
        });
    }

    private static void clientStart(IEventBus modEventBus) {
        if (Minecraft.func_71410_x() != null) {
            ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("numina", "obj"), (IModelLoader)NuminaOBJLoader.INSTANCE);
        }
        EventBusHelper.addListener(Numina.class, modEventBus, ColorHandlerEvent.Block.class, setupEvent -> {
            NuminaSpriteUploader iconUploader = new NuminaSpriteUploader();
            GuiIcon icons = new GuiIcon(iconUploader);
            IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
            if (resourceManager instanceof IReloadableResourceManager) {
                IReloadableResourceManager reloadableResourceManager = (IReloadableResourceManager)resourceManager;
                reloadableResourceManager.func_219534_a((IFutureReloadListener)iconUploader);
            }
            EventBusHelper.addLifecycleListener(Numina.class, modEventBus, FMLLoadCompleteEvent.class, loadCompleteEvent -> IconUtils.setIconInstance(icons));
        });
    }

    private void setup(FMLCommonSetupEvent event) {
        NuminaPackets.registerNuminaPackets();
        HeatCapability.register();
        ColourCapability.register();
        PowerModuleCapability.register();
        ModelSpecNBTCapability.register();
        HighLightCapability.register();
        ChameleonCapability.register();
        CapabilityPlayerKeyStates.register();
        MinecraftForge.EVENT_BUS.register((Object)new PlayerUpdateHandler());
        DeferredWorkQueue.runLater(() -> GlobalEntityTypeAttributes.put((EntityType)((EntityType)NuminaObjects.ARMOR_WORKSTATION__ENTITY_TYPE.get()), (AttributeModifierMap)NuminaArmorStandEntity.setCustomAttributes().func_233813_a_()));
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new FOVUpdateEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)RenderEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new ToolTipEvent());
        ScreenManager.func_216911_a((ContainerType)((ContainerType)NuminaObjects.CHARGING_BASE_CONTAINER_TYPE.get()), ChargingBaseScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)NuminaObjects.ARMOR_STAND_CONTAINER_TYPE.get()), ArmorStandScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)NuminaObjects.SCANNER_CONTAINER.get()), MPSGuiScanner::new);
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof PlayerEntity)) {
            return;
        }
        event.addCapability(new ResourceLocation("numina", "player_keystates"), (ICapabilityProvider)new CapabilityPlayerKeyStates());
    }

    @Mod.EventBusSubscriber(modid="numina", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class MyStaticClientOnlyEventHandler {
        @SubscribeEvent
        public static void loadComplete(FMLLoadCompleteEvent evt) {
            ArmorLayerSetup.loadComplete(evt);
        }
    }
}

