/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.module.powermodule;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.tags.TagUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class PowerModule
implements IPowerModule {
    protected ItemStack module;
    protected final ModuleCategory category;
    protected final ModuleTarget target;
    protected Map<String, List<IPowerModule.IPropertyModifier>> propertyModifiers = new HashMap<String, List<IPowerModule.IPropertyModifier>>();
    Callable<IConfig> moduleConfigGetter;

    public PowerModule(@Nonnull ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> moduleConfigGetterIn) {
        this.module = module;
        this.category = category;
        this.target = target;
        this.moduleConfigGetter = moduleConfigGetterIn;
    }

    @Override
    public ItemStack getModuleStack() {
        return this.module;
    }

    @Override
    public ModuleTarget getTarget() {
        return this.target;
    }

    @Override
    public ModuleCategory getCategory() {
        return this.category;
    }

    Optional<IConfig> getConfig() {
        try {
            return Optional.ofNullable(this.moduleConfigGetter.call());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void addTradeoffProperty(String tradeoffName, String propertyName, double multiplier) {
        double propFromConfig = this.getConfig().map(config -> config.getTradeoffPropertyDoubleOrDefault(this.category, this.module, tradeoffName, propertyName, multiplier)).orElse(multiplier);
        this.addPropertyModifier(propertyName, new IPowerModule.PropertyModifierLinearAdditive(tradeoffName, propFromConfig));
    }

    @Override
    public void addPropertyModifier(String propertyName, IPowerModule.IPropertyModifier modifier) {
        List<IPowerModule.IPropertyModifier> modifiers = this.propertyModifiers.get(propertyName);
        if (modifiers == null) {
            modifiers = new LinkedList<IPowerModule.IPropertyModifier>();
        }
        modifiers.add(modifier);
        this.propertyModifiers.put(propertyName, modifiers);
    }

    @Override
    public void addTradeoffProperty(String tradeoffName, String propertyName, double multiplier, String unit) {
        this.addUnitLabel(propertyName, unit);
        this.addTradeoffProperty(tradeoffName, propertyName, multiplier);
    }

    public void addSimpleTradeoff(String tradeoffName, String firstPropertyName, String firstUnits, double firstPropertyBase, double firstPropertyMultiplier, String secondPropertyName, String secondUnits, double secondPropertyBase, double secondPropertyMultiplier) {
        this.addBaseProperty(firstPropertyName, firstPropertyBase, firstUnits);
        this.addTradeoffProperty(tradeoffName, firstPropertyName, firstPropertyMultiplier);
        this.addBaseProperty(secondPropertyName, secondPropertyBase, secondUnits);
        this.addTradeoffProperty(tradeoffName, secondPropertyName, secondPropertyMultiplier);
    }

    @Override
    public void addBaseProperty(String propertyName, double baseVal) {
        double propFromConfig = this.getConfig().map(config -> config.getBasePropertyDoubleOrDefault(this.category, this.module, propertyName, baseVal)).orElse(baseVal);
        this.addPropertyModifier(propertyName, new IPowerModule.PropertyModifierFlatAdditive(propFromConfig));
    }

    @Override
    public void addBaseProperty(String propertyName, double baseVal, String unit) {
        this.addUnitLabel(propertyName, unit);
        this.addBaseProperty(propertyName, baseVal);
    }

    @Override
    public double applyPropertyModifiers(String propertyName) {
        return this.applyPropertyModifiers(propertyName, TagUtils.getModuleTag(this.module));
    }

    @Override
    public double applyPropertyModifiers(String propertyName, CompoundNBT moduleTag) {
        double propertyValue = 0.0;
        if (this.propertyModifiers.containsKey(propertyName)) {
            Iterable propertyModifiersIterable = this.propertyModifiers.get(propertyName);
            for (IPowerModule.IPropertyModifier modifier : propertyModifiersIterable) {
                propertyValue = modifier.applyModifier(moduleTag, propertyValue);
            }
        }
        return propertyValue;
    }

    @Override
    public Map<String, List<IPowerModule.IPropertyModifier>> getPropertyModifiers() {
        return this.propertyModifiers;
    }

    @Override
    public void addIntTradeoffProperty(String tradeoffName, String propertyName, int multiplier, String unit, int roundTo, int offset) {
        this.addUnitLabel(propertyName, unit);
        int propFromConfig = this.getConfig().map(config -> config.getTradeoffPropertyIntegerOrDefault(this.category, this.module, tradeoffName, propertyName, multiplier)).orElse(multiplier);
        this.addPropertyModifier(propertyName, new IPowerModule.PropertyModifierIntLinearAdditive(tradeoffName, propFromConfig, roundTo, offset));
    }

    @Override
    public boolean isAllowed() {
        return this.getConfig().map(config -> config.isModuleAllowed(this.category, this.module)).orElse(true);
    }
}

