/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.render;

import java.util.List;
import javax.annotation.Nonnull;
import lehjr.numina.common.base.NuminaLogger;
import lehjr.numina.common.capabilities.render.modelspec.EnumSpecType;
import lehjr.numina.common.capabilities.render.modelspec.ModelRegistry;
import lehjr.numina.common.capabilities.render.modelspec.TexturePartSpec;
import lehjr.numina.common.math.Colour;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public interface IModelSpecNBT {
    @Nonnull
    public ItemStack getItemStack();

    public EnumSpecType getSpecType();

    public CompoundNBT getRenderTag();

    public CompoundNBT setRenderTag(CompoundNBT var1, String var2);

    public CompoundNBT getDefaultRenderTag();

    public List<Integer> addNewColourstoList(List<Integer> var1, List<Integer> var2);

    public int[] getColorArray();

    public int getNewColourIndex(List<Integer> var1, List<Integer> var2, Integer var3);

    public CompoundNBT setColorArray(int[] var1);

    default public Colour getColorFromItemStack() {
        try {
            CompoundNBT renderTag = this.getRenderTag();
            if (renderTag == null || renderTag.isEmpty()) {
                return Colour.WHITE;
            }
            if (renderTag.func_74764_b("texSpec")) {
                TexturePartSpec partSpec = (TexturePartSpec)ModelRegistry.getInstance().getPart(renderTag.func_74775_l("texSpec"));
                CompoundNBT specTag = renderTag.func_74775_l("texSpec");
                int index = partSpec.getColourIndex(specTag);
                int[] colours = this.getColorArray();
                if (colours.length > index) {
                    return new Colour(colours[index]);
                }
            }
        }
        catch (Exception e) {
            NuminaLogger.logException("something failed here: ", e);
        }
        return Colour.WHITE;
    }
}

