/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.render.chameleon;

import java.util.Optional;
import javax.annotation.Nonnull;
import lehjr.numina.common.capabilities.IItemStackUpdate;
import lehjr.numina.common.capabilities.render.chameleon.IChameleon;
import lehjr.numina.common.tags.TagUtils;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;

public class Chameleon
implements IChameleon,
IItemStackUpdate,
INBTSerializable<StringNBT> {
    public static final String BLOCK = "block";
    ResourceLocation blockRegName = Blocks.field_150350_a.getRegistryName();
    @Nonnull
    ItemStack module;

    public Chameleon(@Nonnull ItemStack module) {
        this.module = module;
        this.blockRegName = TagUtils.getModuleResourceLocation(module, BLOCK).orElse(Blocks.field_150350_a.getRegistryName());
    }

    @Override
    public Optional<ResourceLocation> getTargetBlockRegName() {
        return Optional.ofNullable(this.blockRegName);
    }

    @Override
    public Optional<Block> getTargetBlock() {
        return this.getTargetBlockRegName().map(regNane -> (Block)ForgeRegistries.BLOCKS.getValue(regNane));
    }

    @Override
    @Nonnull
    public ItemStack getModule() {
        return this.module;
    }

    public StringNBT serializeNBT() {
        if (this.blockRegName != null) {
            return StringNBT.func_229705_a_((String)this.blockRegName.toString());
        }
        return null;
    }

    @Override
    public void setTargetBlockByRegName(ResourceLocation regName) {
        IChameleon.super.setTargetBlockByRegName(regName);
        this.blockRegName = regName;
        this.serializeNBT();
    }

    public void deserializeNBT(StringNBT nbt) {
        if (nbt != null) {
            this.blockRegName = new ResourceLocation(nbt.func_150285_a_());
        }
    }

    @Override
    public void updateFromNBT() {
        CompoundNBT nbt = TagUtils.getModuleTag(this.module);
        if (nbt.func_150297_b(BLOCK, 8)) {
            this.deserializeNBT(StringNBT.func_229705_a_((String)nbt.func_74779_i(BLOCK)));
        } else {
            this.blockRegName = Blocks.field_150350_a.getRegistryName();
        }
    }
}

