/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.tags;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;

public class TagUtils {
    public static final String TAG_ITEM_PREFIX = "MMModItem";
    public static final String TAG_MODULE_PREFIX = "MMModModule";

    public static CompoundNBT getMuseItemTag(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return new CompoundNBT();
        }
        CompoundNBT stackTag = stack.func_196082_o();
        CompoundNBT properties = stackTag.func_74764_b(TAG_ITEM_PREFIX) ? stackTag.func_74775_l(TAG_ITEM_PREFIX) : new CompoundNBT();
        stackTag.func_218657_a(TAG_ITEM_PREFIX, (INBT)properties);
        stack.func_77982_d(stackTag);
        return properties;
    }

    public static CompoundNBT getModuleTag(@Nonnull ItemStack module) {
        if (module.func_190926_b()) {
            return new CompoundNBT();
        }
        CompoundNBT stackTag = module.func_196082_o();
        CompoundNBT properties = stackTag.func_74764_b(TAG_MODULE_PREFIX) ? stackTag.func_74775_l(TAG_MODULE_PREFIX) : new CompoundNBT();
        stackTag.func_218657_a(TAG_MODULE_PREFIX, (INBT)properties);
        module.func_77982_d(stackTag);
        return properties;
    }

    public static float getModuleFloatOrZero(@Nonnull ItemStack stack, String string) {
        return TagUtils.getFloatOrZero(TagUtils.getModuleTag(stack), string);
    }

    public static float getModularItemFloatOrZero(@Nonnull ItemStack stack, String string) {
        return TagUtils.getFloatOrZero(TagUtils.getMuseItemTag(stack), string);
    }

    public static float getFloatOrZero(CompoundNBT nbt, String tagName) {
        return nbt.func_150297_b(tagName, 5) ? nbt.func_74760_g(tagName) : 0.0f;
    }

    public static void setModularItemFloatOrRemove(@Nonnull ItemStack stack, String string, float value) {
        TagUtils.setFloatOrRemove(TagUtils.getMuseItemTag(stack), string, value);
    }

    public static void setModuleFloatOrRemove(@Nonnull ItemStack stack, String string, float value) {
        TagUtils.setFloatOrRemove(TagUtils.getModuleTag(stack), string, value);
    }

    public static void setFloatOrRemove(CompoundNBT itemProperties, String string, float value) {
        if (itemProperties != null) {
            if (Float.compare(value, 0.0f) == 0) {
                itemProperties.func_82580_o(string);
            } else {
                itemProperties.func_74776_a(string, value);
            }
        }
    }

    public static double getModuleDoubleOrZero(@Nonnull ItemStack stack, String string) {
        return TagUtils.getDoubleOrZero(TagUtils.getModuleTag(stack), string);
    }

    public static double getModularItemDoubleOrZero(@Nonnull ItemStack stack, String string) {
        return TagUtils.getDoubleOrZero(TagUtils.getMuseItemTag(stack), string);
    }

    public static double getDoubleOrZero(CompoundNBT nbt, String tagName) {
        return nbt.func_150297_b(tagName, 6) ? nbt.func_74769_h(tagName) : 0.0;
    }

    public static void setModularItemDoubleOrRemove(@Nonnull ItemStack stack, String string, double value) {
        TagUtils.setDoubleOrRemove(TagUtils.getMuseItemTag(stack), string, value);
    }

    public static void setModuleDoubleOrRemove(@Nonnull ItemStack stack, String string, double value) {
        TagUtils.setDoubleOrRemove(TagUtils.getModuleTag(stack), string, value);
    }

    public static void setDoubleOrRemove(CompoundNBT itemProperties, String string, double value) {
        if (itemProperties != null) {
            if (value == 0.0) {
                itemProperties.func_82580_o(string);
            } else {
                itemProperties.func_74780_a(string, value);
            }
        }
    }

    public static int getModuleIntOrZero(@Nonnull ItemStack module, String string) {
        return TagUtils.getIntOrZero(TagUtils.getModuleTag(module), string);
    }

    public static int getModularItemIntOrZero(@Nonnull ItemStack module, String string) {
        return TagUtils.getIntOrZero(TagUtils.getMuseItemTag(module), string);
    }

    static int getIntOrZero(CompoundNBT nbt, String tagName) {
        return nbt.func_150297_b(tagName, 3) ? nbt.func_74762_e(tagName) : 0;
    }

    public static void setModuleIntOrRemove(@Nonnull ItemStack stack, String tagName, int value, boolean remove) {
        TagUtils.setIntOrRemove(TagUtils.getModuleTag(stack), tagName, value, remove);
    }

    public static void setModularItemIntOrRemove(@Nonnull ItemStack stack, String tagName, int value, boolean remove) {
        TagUtils.setIntOrRemove(TagUtils.getMuseItemTag(stack), tagName, value, remove);
    }

    public static void setIntOrRemove(@Nonnull CompoundNBT nbt, String tagName, int value, boolean remove) {
        if (value == 0 && remove) {
            nbt.func_82580_o(tagName);
        } else {
            nbt.func_74768_a(tagName, value);
        }
    }

    public static boolean getModuleBooleanOrSetDefault(@Nonnull ItemStack module, String tagName, boolean defBool) {
        CompoundNBT moduleTag = TagUtils.getModuleTag(module);
        if (moduleTag.func_150297_b(tagName, 1)) {
            return TagUtils.getBooleanOrFalse(moduleTag, tagName);
        }
        moduleTag.func_74757_a(tagName, defBool);
        return defBool;
    }

    public static boolean getModuleBooleanOrFalse(@Nonnull ItemStack module, String string) {
        return TagUtils.getBooleanOrFalse(TagUtils.getModuleTag(module), string);
    }

    public static boolean getItemBooleanOrFalse(@Nonnull ItemStack module, String string) {
        return TagUtils.getBooleanOrFalse(TagUtils.getMuseItemTag(module), string);
    }

    static boolean getBooleanOrFalse(CompoundNBT nbt, String tagName) {
        return nbt.func_150297_b(tagName, 1) ? nbt.func_74767_n(tagName) : false;
    }

    public static void setModuleBoolean(@Nonnull ItemStack module, String string, boolean value) {
        TagUtils.getModuleTag(module).func_74757_a(string, value);
    }

    public static void setModularItemBoolean(@Nonnull ItemStack module, String string, boolean value) {
        TagUtils.getMuseItemTag(module).func_74757_a(string, value);
    }

    public static void setModuleResourceLocation(@Nonnull ItemStack module, String string, ResourceLocation value) {
        TagUtils.getModuleTag(module).func_74778_a(string, value.toString());
    }

    public static Optional<ResourceLocation> getModuleResourceLocation(@Nonnull ItemStack module, String string) {
        CompoundNBT moduleTag = TagUtils.getModuleTag(module);
        if (moduleTag.func_150297_b(string, 8)) {
            return Optional.of(new ResourceLocation(moduleTag.func_74779_i(string)));
        }
        return Optional.empty();
    }
}

