/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class CraftTweakerModList {
    private final SortedSet<IModInfo> addedInfos = new TreeSet<IModInfo>(Comparator.comparing(IModInfo::getModId));

    public void add(ModFileScanData scanData) {
        scanData.getIModInfoData().stream().flatMap(info -> info.getMods().stream()).forEach(this::add);
    }

    private void add(IModInfo info) {
        this.addedInfos.add(info);
    }

    public void printToLog() {
        CraftTweakerAPI.logInfo("The following mods have explicit CraftTweaker support:", new Object[0]);
        this.addedInfos.stream().map(this::formatInfo).forEach(x$0 -> CraftTweakerAPI.logDump(x$0, new Object[0]));
    }

    private String formatInfo(IModInfo info) {
        return String.format("'%s' at version '%s'", info.getModId(), info.getVersion());
    }
}

