/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.serializer;

import com.blamejared.crafttweaker.api.item.IngredientList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public enum IngredientListSerializer implements IIngredientSerializer<IngredientList>
{
    INSTANCE;


    public IngredientList parse(PacketBuffer buffer) {
        return new IngredientList(Stream.generate(() -> Ingredient.func_199566_b((PacketBuffer)buffer)).limit(buffer.func_150792_a()).collect(Collectors.toList()));
    }

    public IngredientList parse(JsonObject json) {
        if (!(json.get("ingredients") instanceof JsonArray)) {
            throw new JsonParseException("No 'ingredients' array to parse!");
        }
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (JsonElement jsonElement : json.getAsJsonArray("ingredients")) {
            ingredients.add(Ingredient.func_199802_a((JsonElement)jsonElement));
        }
        return new IngredientList(ingredients);
    }

    public void write(PacketBuffer buffer, IngredientList ingredient) {
        CompoundIngredient.Serializer.INSTANCE.write(buffer, (CompoundIngredient)ingredient);
    }
}

