/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.brewing;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.impl.actions.brewing.ActionBrewingBase;
import com.blamejared.crafttweaker.impl_native.potion.ExpandPotion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.registries.IRegistryDelegate;

public class ActionRemoveBrewingRecipeByPotionOutput
extends ActionBrewingBase {
    private final List<PotionBrewing.MixPredicate<Potion>> removed = new ArrayList<PotionBrewing.MixPredicate<Potion>>();
    private final Potion output;

    public ActionRemoveBrewingRecipeByPotionOutput(List<IBrewingRecipe> recipes, Potion output) {
        super(recipes);
        this.output = output;
    }

    @Override
    public void apply() {
        Iterator iterator = PotionBrewing.field_185213_a.iterator();
        while (iterator.hasNext()) {
            PotionBrewing.MixPredicate mix = (PotionBrewing.MixPredicate)iterator.next();
            if (mix.field_185200_c == null) {
                throw new RuntimeException("Error getting potion from mix: " + mix + "! Please make an issue on the issue tracker!");
            }
            if (!((Potion)mix.field_185200_c.get()).equals(this.output)) continue;
            this.removed.add((PotionBrewing.MixPredicate<Potion>)mix);
            iterator.remove();
        }
    }

    @Override
    public void undo() {
        for (PotionBrewing.MixPredicate<Potion> potion : this.removed) {
            IRegistryDelegate potionInput = potion.field_185198_a;
            Ingredient itemReagent = this.getItemReagent(potion);
            IRegistryDelegate potionOutput = potion.field_185200_c;
            if (potionInput == null || itemReagent == null || potionOutput == null) {
                CraftTweakerAPI.logError("Error getting mix entries! potionInput: %s, itemReagent: %s, potionOutput: %s", potionInput, itemReagent, potionOutput);
                continue;
            }
            PotionBrewing.func_193357_a((Potion)((Potion)potionInput.get()), (Item)itemReagent.func_193365_a()[0].func_77973_b(), (Potion)((Potion)potionOutput.get()));
        }
    }

    @Override
    public String describe() {
        return "Removing Brewing recipes that output: " + ExpandPotion.getCommandString(this.output);
    }

    @Override
    public String describeUndo() {
        return "Undoing removal of Brewing recipes that output: " + ExpandPotion.getCommandString(this.output);
    }
}

