/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.brackets;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.BracketResolver;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.brackets.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.impl.entity.MCEntityType;
import com.blamejared.crafttweaker.impl.fluid.MCFluidStack;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.util.text.MCTextFormatting;
import com.blamejared.crafttweaker.impl_native.block.material.ExpandMaterial;
import com.blamejared.crafttweaker.impl_native.blocks.ExpandBlockState;
import com.blamejared.crafttweaker.impl_native.util.ExpandDamageSource;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.BracketHandlers")
@Document(value="vanilla/api/BracketHandlers")
public class BracketHandlers {
    @ZenCodeType.Method
    @BracketResolver(value="attribute")
    public static Attribute getAttribute(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Attribute BEP <attribute:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get attribute with name: <attribute:" + tokens + ">! Syntax is <attribute:modid:name>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (!ForgeRegistries.ATTRIBUTES.containsKey(key)) {
            throw new IllegalArgumentException("Could not get attribute with name: <attribute:" + tokens + ">! Attribute does not appear to exist!");
        }
        return (Attribute)ForgeRegistries.ATTRIBUTES.getValue(key);
    }

    @ZenCodeType.Method
    @BracketResolver(value="block")
    public static Block getBlock(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Block BEP <block:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get block with name: <block:" + tokens + ">! Syntax is <block:modid:itemname>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (!ForgeRegistries.BLOCKS.containsKey(key)) {
            throw new IllegalArgumentException("Could not get block with name: <block:" + tokens + ">! Block does not appear to exist!");
        }
        return (Block)ForgeRegistries.BLOCKS.getValue(key);
    }

    @ZenCodeType.Method
    @BracketResolver(value="blockmaterial")
    public static Material getBlockMaterial(String tokens) {
        Material material = ExpandMaterial.tryGet(tokens);
        if (material != null) {
            return material;
        }
        try {
            for (Field field : Material.class.getFields()) {
                if (!field.getName().equalsIgnoreCase(tokens)) continue;
                return (Material)field.get(null);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Error getting blockmaterial <blockmaterial:" + tokens + ">!", e);
        }
        try {
            Field field = ObfuscationReflectionHelper.findField(Material.class, (String)tokens.toUpperCase());
            return (Material)field.get(null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not find blockmaterial <blockmaterial:" + tokens + ">!");
        }
    }

    @ZenCodeType.Method
    @BracketResolver(value="blockstate")
    public static BlockState getBlockState(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("BlockState BEP <blockstate:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":", 4)).length > 1) {
            String properties;
            String blockName = split[0] + ":" + split[1];
            String string = properties = split.length > 2 ? split[2] : "";
            if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(blockName))) {
                CraftTweakerAPI.logThrowing("Error creating BlockState!", new IllegalArgumentException("Could not get BlockState from: <blockstate:" + tokens + ">! The block does not appear to exist!"), new Object[0]);
            } else {
                return BracketHandlers.getBlockState(blockName, properties);
            }
        }
        CraftTweakerAPI.logThrowing("Error creating BlockState!", new IllegalArgumentException("Could not get BlockState from: <blockstate:" + tokens + ">!"), new Object[0]);
        return null;
    }

    public static BlockState getBlockState(String name, String properties) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
        if (block == null) {
            return null;
        }
        BlockState blockState = block.func_176223_P();
        if (properties != null && !properties.isEmpty()) {
            for (String propertyPair : properties.split(",")) {
                String[] splitPair = propertyPair.split("=");
                if (splitPair.length != 2) {
                    CraftTweakerAPI.logWarning("Invalid blockstate property format '" + propertyPair + "'. Using default property value.", new Object[0]);
                    continue;
                }
                blockState = ExpandBlockState.withProperty(blockState, splitPair[0], splitPair[1]);
            }
        }
        return blockState;
    }

    @ZenCodeType.Method
    @BracketResolver(value="directionaxis")
    public static Direction.Axis getDirectionAxis(String tokens) {
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("DirectionAxis BEP <directionaxis:%s> does not seem to be lower-cased!", tokens);
        }
        if (tokens.contains(":")) {
            throw new IllegalArgumentException("Could not get axis with name: <directionaxis:" + tokens + ">! Syntax is <directionaxis:axis>");
        }
        Direction.Axis axis = Direction.Axis.func_176717_a((String)tokens);
        if (axis == null) {
            throw new IllegalArgumentException("Could not get axis with name: <directionaxis:" + tokens + ">! Axis does not appear to exist!");
        }
        return axis;
    }

    @ZenCodeType.Method
    @BracketResolver(value="equipmentslottype")
    public static EquipmentSlotType getEquipmentSlotType(String tokens) {
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("EquipmentSlotType BEP <equipmentslottype:%s> does not seem to be lower-cased!", tokens);
        }
        return EquipmentSlotType.func_188451_a((String)tokens);
    }

    @BracketResolver(value="effect")
    @ZenCodeType.Method
    public static Effect getEffect(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Effect BEP <effect:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get effect with name: <effect:" + tokens + ">! Syntax is <effect:modid:potionname>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (!ForgeRegistries.POTIONS.containsKey(key)) {
            throw new IllegalArgumentException("Could not get effect with name: <potion:" + tokens + ">! Effect does not appear to exist!");
        }
        return (Effect)ForgeRegistries.POTIONS.getValue(key);
    }

    @ZenCodeType.Method
    @BracketResolver(value="enchantment")
    public static Enchantment getEnchantment(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Enchantment BEP <enchantment:%s> does not seem to be lower-case!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get enchantment '" + tokens + "': not a valid bracket handler, syntax is <enchantment:modid:name>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (!ForgeRegistries.ENCHANTMENTS.containsKey(key)) {
            throw new IllegalArgumentException("Could not get enchantment '" + tokens + "': the enchantment does not appear to exist");
        }
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(key);
    }

    @ZenCodeType.Method
    @BracketResolver(value="entityclassification")
    public static EntityClassification getEntityClassification(String tokens) {
        int length = tokens.split(":").length;
        if (length == 0 || length > 1) {
            CraftTweakerAPI.logError("Could not get EntityClassification <entityclassification:%s>", tokens);
            return null;
        }
        if (Arrays.stream(EntityClassification.values()).noneMatch(entityClassification -> entityClassification.name().equalsIgnoreCase(tokens))) {
            CraftTweakerAPI.logError("Could not get EntityClassification <entityclassification:%s>", tokens);
            return null;
        }
        return EntityClassification.valueOf((String)tokens.toUpperCase());
    }

    @ZenCodeType.Method
    @BracketResolver(value="entitytype")
    public static MCEntityType getEntityType(String tokens) {
        int length = tokens.split(":").length;
        if (length == 0 || length > 2) {
            throw new IllegalArgumentException("Could not get entitytype <entitytype:" + tokens + ">");
        }
        ResourceLocation resourceLocation = new ResourceLocation(tokens);
        if (!ForgeRegistries.ENTITIES.containsKey(resourceLocation)) {
            throw new IllegalArgumentException("Could not get entitytype <entitytype:" + tokens + ">");
        }
        return new MCEntityType((EntityType)Objects.requireNonNull(ForgeRegistries.ENTITIES.getValue(resourceLocation)));
    }

    @ZenCodeType.Method
    @BracketResolver(value="fluid")
    public static IFluidStack getFluidStack(String tokens) {
        ResourceLocation resourceLocation = ResourceLocation.func_208304_a((String)tokens);
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Could not get fluid for <fluid:" + tokens + ">. Syntax is <fluid:modid:fluidname>");
        }
        if (!ForgeRegistries.FLUIDS.containsKey(resourceLocation)) {
            throw new IllegalArgumentException("Could not get fluid for <fluid:" + tokens + ">. Fluid does not appear to exist!");
        }
        return new MCFluidStack(new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(resourceLocation), 1));
    }

    @BracketResolver(value="item")
    @ZenCodeType.Method
    public static IItemStack getItem(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Item BEP <item:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get item with name: <item:" + tokens + ">! Syntax is <item:modid:itemname>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (!ForgeRegistries.ITEMS.containsKey(key)) {
            throw new IllegalArgumentException("Could not get item with name: <item:" + tokens + ">! Item does not appear to exist!");
        }
        ItemStack value = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(key));
        return new MCItemStack(value);
    }

    @BracketResolver(value="potion")
    @ZenCodeType.Method
    public static Potion getPotion(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Potion BEP <potion:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get potion with name: <potion:" + tokens + ">! Syntax is <potion:modid:potionname>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (!ForgeRegistries.POTION_TYPES.containsKey(key)) {
            throw new IllegalArgumentException("Could not get potion with name: <potion:" + tokens + ">! Potion does not appear to exist!");
        }
        return (Potion)ForgeRegistries.POTION_TYPES.getValue(key);
    }

    @ZenCodeType.Method
    public static IRecipeManager getRecipeManager(String tokens) {
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("RecipeType BEP <recipetype:%s> does not seem to be lower-cased!", tokens);
        }
        if (tokens.equalsIgnoreCase("crafttweaker:scripts")) {
            throw new IllegalArgumentException("Nice try, but there's no reason you need to access the <recipetype:crafttweaker:scripts> recipe manager!");
        }
        ResourceLocation key = new ResourceLocation(tokens);
        IRecipeManager result = RecipeTypeBracketHandler.getOrDefault(key);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Could not get RecipeType with name: <recipetype:" + tokens + ">! RecipeType does not appear to exist!");
    }

    @ZenCodeType.Method
    @BracketResolver(value="resource")
    public static ResourceLocation getResourceLocation(String tokens) {
        return new ResourceLocation(tokens);
    }

    @ZenCodeType.Method
    @BracketResolver(value="formatting")
    public static MCTextFormatting getTextFormatting(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Formatting BEP <formatting:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 1) {
            throw new IllegalArgumentException("Could not get format with name: <formatting:" + tokens + ">! Syntax is <formatting:format>");
        }
        if (TextFormatting.func_96300_b((String)split[0]) == null) {
            throw new IllegalArgumentException("Could not get format with name: <formatting:" + tokens + ">! format does not appear to exist!");
        }
        return new MCTextFormatting(TextFormatting.func_96300_b((String)split[0]));
    }

    @ZenCodeType.Method
    @BracketResolver(value="profession")
    public static VillagerProfession getProfession(String tokens) {
        int length = tokens.split(":").length;
        if (length == 0 || length > 2) {
            throw new IllegalArgumentException("Could not get profession <profession:" + tokens + ">");
        }
        ResourceLocation resourceLocation = new ResourceLocation(tokens);
        if (!ForgeRegistries.PROFESSIONS.containsKey(resourceLocation)) {
            throw new IllegalArgumentException("Could not get profession <profession:" + tokens + ">");
        }
        return (VillagerProfession)ForgeRegistries.PROFESSIONS.getValue(resourceLocation);
    }

    @ZenCodeType.Method
    @BracketResolver(value="biome")
    public static Biome getBiome(String tokens) {
        int length = tokens.split(":").length;
        if (length != 2) {
            throw new IllegalArgumentException("Could not get biome with name: <biome:" + tokens + ">! Syntax is <biome:modid:biomeName>");
        }
        ResourceLocation resourceLocation = new ResourceLocation(tokens);
        if (!ForgeRegistries.BIOMES.containsKey(resourceLocation)) {
            throw new IllegalArgumentException("Could not get biome <biome:" + tokens + ">");
        }
        return (Biome)ForgeRegistries.BIOMES.getValue(resourceLocation);
    }

    @ZenCodeType.Method
    @BracketResolver(value="damagesource")
    public static DamageSource getDamageSource(String tokens) {
        return ExpandDamageSource.PRE_REGISTERED_DAMAGE_SOURCES.getOrDefault(tokens, new DamageSource(tokens));
    }

    @ZenCodeType.Method
    @BracketResolver(value="tooltype")
    public static ToolType getToolType(String tokens) {
        return ToolType.get((String)tokens);
    }

    @ZenCodeType.Method
    @BracketResolver(value="itemgroup")
    public static ItemGroup getItemGroup(String tokens) {
        return Arrays.stream(ItemGroup.field_78032_a).filter(g -> g.func_200300_c().equals(tokens)).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find itemgroup for '<itemgroup:" + tokens + ">'!"));
    }
}

