/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands.custom;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.commands.custom.MCCommand;
import com.blamejared.crafttweaker.impl.commands.custom.MCCommandNode;
import com.blamejared.crafttweaker.impl.commands.custom.MCCommandSource;
import com.blamejared.crafttweaker.impl.commands.custom.MCLiteralArgumentBuilder;
import com.blamejared.crafttweaker.impl.commands.custom.MCRedirectModifier;
import com.blamejared.crafttweaker.impl.commands.custom.MCRequiredArgumentBuilder;
import com.blamejared.crafttweaker.impl.commands.custom.MCSingleRedirectModifier;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.commands.custom.MCArgumentBuilder")
@Document(value="vanilla/api/commands/custom/MCArgumentBuilder")
public class MCArgumentBuilder {
    private final ArgumentBuilder<CommandSource, ?> internal;

    public MCArgumentBuilder(ArgumentBuilder<CommandSource, ?> internal) {
        this.internal = internal;
    }

    public static MCArgumentBuilder convert(ArgumentBuilder<CommandSource, ?> internal) {
        if (internal == null) {
            return null;
        }
        if (internal instanceof LiteralArgumentBuilder) {
            return new MCLiteralArgumentBuilder((LiteralArgumentBuilder<CommandSource>)((LiteralArgumentBuilder)internal));
        }
        if (internal instanceof RequiredArgumentBuilder) {
            return new MCRequiredArgumentBuilder((RequiredArgumentBuilder)internal);
        }
        return new MCArgumentBuilder(internal);
    }

    public ArgumentBuilder<CommandSource, ?> getInternal() {
        return this.internal;
    }

    @ZenCodeType.Method
    public MCArgumentBuilder then(MCArgumentBuilder argument) {
        ArgumentBuilder then = this.getInternal().then(argument.getInternal());
        return this.getInternal() == then ? this : MCArgumentBuilder.convert(then);
    }

    @ZenCodeType.Method
    public MCArgumentBuilder then(MCCommandNode argument) {
        ArgumentBuilder then = this.getInternal().then(argument.getInternal());
        return this.getInternal() == then ? this : MCArgumentBuilder.convert(then);
    }

    @ZenCodeType.Method
    public Collection<MCCommandNode> getArguments() {
        return this.getInternal().getArguments().stream().map(MCCommandNode::new).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    public MCArgumentBuilder executes(MCCommand command) {
        ArgumentBuilder then = this.getInternal().executes(command.getInternal());
        return this.getInternal() == then ? this : MCArgumentBuilder.convert(then);
    }

    @ZenCodeType.Method
    public MCCommand getCommand() {
        return new MCCommand((Command<CommandSource>)this.getInternal().getCommand());
    }

    @ZenCodeType.Method
    public MCArgumentBuilder requires(Predicate<MCCommandSource> requirement) {
        ArgumentBuilder then = this.getInternal().requires(commandSource -> requirement.test(new MCCommandSource((CommandSource)commandSource)));
        return this.getInternal() == then ? this : MCArgumentBuilder.convert(then);
    }

    @ZenCodeType.Method
    public Predicate<MCCommandSource> getRequirement() {
        return mcCommandSource -> this.getInternal().getRequirement().test(mcCommandSource.getInternal());
    }

    @ZenCodeType.Method
    public MCArgumentBuilder redirect(MCCommandNode target) {
        ArgumentBuilder redirect = this.getInternal().redirect(target.getInternal());
        return redirect == this.getInternal() ? this : MCArgumentBuilder.convert(redirect);
    }

    @ZenCodeType.Method
    public MCArgumentBuilder redirect(MCCommandNode target, MCSingleRedirectModifier modifier) {
        ArgumentBuilder redirect = this.getInternal().redirect(target.getInternal(), modifier.getInternal());
        return redirect == this.getInternal() ? this : MCArgumentBuilder.convert(redirect);
    }

    @ZenCodeType.Method
    public MCArgumentBuilder fork(MCCommandNode target, MCRedirectModifier modifier) {
        ArgumentBuilder fork = this.getInternal().fork(target.getInternal(), modifier.getInternal());
        return fork == this.getInternal() ? this : MCArgumentBuilder.convert(fork);
    }

    @ZenCodeType.Method
    public MCArgumentBuilder forward(MCCommandNode target, MCRedirectModifier modifier, boolean fork) {
        ArgumentBuilder forward = this.getInternal().forward(target.getInternal(), modifier.getInternal(), fork);
        return forward == this.getInternal() ? this : MCArgumentBuilder.convert(forward);
    }

    @ZenCodeType.Method
    public MCCommandNode getRedirect() {
        return MCCommandNode.convert((CommandNode<CommandSource>)this.getInternal().getRedirect());
    }

    @ZenCodeType.Method
    public MCRedirectModifier getRedirectModifier() {
        return new MCRedirectModifier((RedirectModifier<CommandSource>)this.getInternal().getRedirectModifier());
    }

    @ZenCodeType.Method
    public boolean isFork() {
        return this.getInternal().isFork();
    }

    @ZenCodeType.Method
    public MCCommandNode build() {
        return MCCommandNode.convert((CommandNode<CommandSource>)this.getInternal().build());
    }

    @ZenCodeType.Method
    public boolean equals(Object o) {
        return o instanceof MCArgumentBuilder && this.getInternal().equals(((MCArgumentBuilder)o).getInternal());
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean opEquals(Object o) {
        return this.equals(o);
    }

    @ZenCodeType.Method
    public int hashCode() {
        return this.getInternal().hashCode();
    }

    @ZenCodeType.Method
    public String toString() {
        return this.getInternal().toString();
    }

    @ZenCodeType.Caster(implicit=true)
    public String asString() {
        return this.toString();
    }
}

