/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.data;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.ICollectionData;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.INumberData;
import com.blamejared.crafttweaker.impl.data.LongData;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.LongArrayData")
@ZenRegister
@Document(value="vanilla/api/data/LongArrayData")
public class LongArrayData
implements ICollectionData {
    private final LongArrayNBT internal;

    public LongArrayData(LongArrayNBT internal) {
        this.internal = internal;
    }

    @ZenCodeType.Constructor
    public LongArrayData(long[] internal) {
        this.internal = new LongArrayNBT(internal);
    }

    @Override
    public IData copy() {
        return new LongArrayData(this.getInternal());
    }

    @Override
    public IData copyInternal() {
        return new LongArrayData(this.getInternal().func_74737_b());
    }

    public LongArrayNBT getInternal() {
        return this.internal;
    }

    @Override
    public LongData setAt(int index, IData value) {
        if (value instanceof NumberNBT) {
            return new LongData(this.getInternal().set(index, LongNBT.func_229698_a_((long)((INumberData)value).getLong())));
        }
        return null;
    }

    @Override
    public void add(int index, IData value) {
        if (value instanceof INumberData) {
            this.getInternal().add(index, LongNBT.func_229698_a_((long)((INumberData)value).getInt()));
        }
    }

    @Override
    public void add(IData value) {
        if (value instanceof INumberData) {
            this.getInternal().add((Object)LongNBT.func_229698_a_((long)((INumberData)value).getInt()));
        }
    }

    @Override
    public LongData remove(int index) {
        return new LongData(this.getInternal().remove(index));
    }

    @Override
    public IData getAt(int index) {
        return new LongData(this.getInternal().get(index));
    }

    @Override
    public int size() {
        return this.getInternal().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getInternal().isEmpty();
    }

    @Override
    public void clear() {
        this.getInternal().clear();
    }

    @Override
    public String asString() {
        StringBuilder result = new StringBuilder();
        result.append('[');
        boolean first = true;
        for (LongNBT nbt : this.getInternal()) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(nbt.func_150291_c());
        }
        result.append(']');
        return result.toString();
    }

    @Override
    public ITextComponent asFormattedComponent(String indentation, int indentDepth) {
        IFormattableTextComponent as = new StringTextComponent(" as ").func_240699_a_(IData.SYNTAX_HIGHLIGHTING_AS);
        IFormattableTextComponent baseType = new StringTextComponent("long").func_240699_a_(IData.SYNTAX_HIGHLIGHTING_TYPE);
        IFormattableTextComponent type = new StringTextComponent("long[]").func_240699_a_(IData.SYNTAX_HIGHLIGHTING_TYPE);
        StringTextComponent component = new StringTextComponent("[");
        for (int i = 0; i < this.size(); ++i) {
            IFormattableTextComponent child = new StringTextComponent(this.getAt(i).toJsonString()).func_240699_a_(IData.SYNTAX_HIGHLIGHTING_NUMBER);
            component.func_240702_b_(i == 0 ? "" : " ").func_230529_a_((ITextComponent)child);
            if (i == this.size() - 1) continue;
            component.func_240702_b_(",");
        }
        component.func_240702_b_("]").func_230529_a_((ITextComponent)as).func_230529_a_((ITextComponent)type);
        return component;
    }

    @Override
    public List<IData> asList() {
        long[] asLongArray = this.getInternal().func_197652_h();
        ArrayList<IData> list = new ArrayList<IData>(asLongArray.length);
        for (long l : asLongArray) {
            list.add(new LongData(l));
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongArrayData that = (LongArrayData)o;
        return this.internal.equals((Object)that.internal);
    }

    public int hashCode() {
        return this.internal.hashCode();
    }
}

