/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.replacement;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.impl.item.MCIngredientList;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;

public final class StackTargetingReplacementRule
implements IReplacementRule {
    private final IItemStack from;
    private final IIngredient to;

    private StackTargetingReplacementRule(IItemStack from, IIngredient to) {
        this.from = from.copy();
        this.to = to;
    }

    public static IReplacementRule create(IItemStack from, IIngredient to) {
        return to instanceof IItemStack && from.matches((IItemStack)to) ? IReplacementRule.EMPTY : new StackTargetingReplacementRule(from, to);
    }

    @Override
    public <T, U extends IRecipe<?>> Optional<T> getReplacement(T ingredient, Class<T> type, U recipe) {
        return IReplacementRule.chain(IReplacementRule.withType(ingredient, type, recipe, IIngredient.class, this::getIIngredientReplacement), IReplacementRule.withType(ingredient, type, recipe, Ingredient.class, this::getIngredientReplacement));
    }

    private <U extends IRecipe<?>> Optional<IIngredient> getIIngredientReplacement(IIngredient ingredient, U recipe) {
        Object[] newItems;
        Object[] oldItems = ingredient.getItems();
        return Arrays.equals(oldItems, newItems = (IIngredient[])Arrays.stream(oldItems).map(this::getStackReplacement).toArray(IIngredient[]::new)) ? Optional.empty() : Optional.of(new MCIngredientList((IIngredient[])newItems));
    }

    private <U extends IRecipe<?>> Optional<Ingredient> getIngredientReplacement(Ingredient ingredient, U recipe) {
        return this.getIIngredientReplacement(IIngredient.fromIngredient(ingredient), recipe).map(IIngredient::asVanillaIngredient);
    }

    private IIngredient getStackReplacement(IItemStack original) {
        return this.from.matches(original) ? this.to : original;
    }

    @Override
    public String describe() {
        return String.format("Replacing stacks %s --> %s", this.from.getCommandString(), this.to.getCommandString());
    }
}

