/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.util;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.ZenWrapper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.util.Direction")
@Document(value="vanilla/api/util/Direction")
@ZenWrapper(wrappedClass="net.minecraft.util.Direction", conversionMethodFormat="%s.getInternal()", displayStringFormat="%s.getInternal.toString()", creationMethodFormat="MCDirection.get(%s)")
public enum MCDirection {
    north(Direction.NORTH),
    south(Direction.SOUTH),
    east(Direction.EAST),
    west(Direction.WEST),
    up(Direction.UP),
    down(Direction.DOWN);

    @ZenCodeType.Field
    public static final MCDirection[] sides;
    private static final Map<Direction, MCDirection> DIRECTION_MAP;
    private final Direction internal;

    private MCDirection(Direction internal) {
        this.internal = internal;
    }

    public static MCDirection get(Direction internal) {
        return DIRECTION_MAP.get(internal);
    }

    @ZenCodeType.Getter(value="index")
    public int getIndex() {
        return this.getInternal().func_176745_a();
    }

    @ZenCodeType.Getter(value="horizontalIndex")
    public int getHorizontalIndex() {
        return this.getInternal().func_176736_b();
    }

    @ZenCodeType.Getter(value="axisOffset")
    public int getAxisOffset() {
        return this.getInternal().func_176743_c().func_179524_a();
    }

    @ZenCodeType.Getter(value="opposite")
    public MCDirection getOpposite() {
        return DIRECTION_MAP.get(this.getInternal().func_176734_d());
    }

    @ZenCodeType.Method
    public MCDirection rotateY() {
        return DIRECTION_MAP.get(this.getInternal().func_176746_e());
    }

    @ZenCodeType.Method
    public MCDirection rotateYCCW() {
        return DIRECTION_MAP.get(this.getInternal().func_176735_f());
    }

    @ZenCodeType.Getter(value="xOffset")
    public int getXOffset() {
        return this.getInternal().func_82601_c();
    }

    @ZenCodeType.Getter(value="yOffset")
    public int getYOffset() {
        return this.getInternal().func_96559_d();
    }

    @ZenCodeType.Getter(value="zOffset")
    public int getZOffset() {
        return this.getInternal().func_82599_e();
    }

    @ZenCodeType.Getter(value="axis")
    public Direction.Axis getAxis() {
        return this.getInternal().func_176740_k();
    }

    @ZenCodeType.Getter(value="horizontalAngle")
    public float getHorizontalAngle() {
        return this.getInternal().func_185119_l();
    }

    @ZenCodeType.Getter(value="name")
    public String getName() {
        return this.getInternal().func_176742_j();
    }

    public Direction getInternal() {
        return this.internal;
    }

    static {
        sides = new MCDirection[]{north, south, west, east};
        DIRECTION_MAP = (Map)Util.func_200696_a(new HashMap(), map -> {
            map.put(Direction.NORTH, north);
            map.put(Direction.SOUTH, south);
            map.put(Direction.EAST, east);
            map.put(Direction.WEST, west);
            map.put(Direction.UP, up);
            map.put(Direction.DOWN, down);
        });
    }
}

