/*
 * Decompiled with CFR 0.152.
 */
package vice.magnesium_extras.mixins.SodiumConfig;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.sodium.client.gui.SodiumOptionsGUI;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import net.minecraft.client.gui.screen.Screen;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vice.magnesium_extras.config.MagnesiumExtrasConfig;

@Pseudo
@Mixin(value={SodiumOptionsGUI.class})
public abstract class ZoomSettingsPage {
    @Shadow
    @Final
    private List<OptionPage> pages;
    private static final SodiumOptionsStorage sodiumOpts = new SodiumOptionsStorage();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void DynamicLights(Screen prevScreen, CallbackInfo ci) {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        OptionImpl zoomScrolling = OptionImpl.createBuilder(Boolean.class, (OptionStorage)sodiumOpts).setName("Zoom Scrolling").setTooltip("Allows using scroll wheel to adjust zoom amount.").setControl(TickBoxControl::new).setBinding((options, value) -> MagnesiumExtrasConfig.zoomScrolling.set(value), options -> (Boolean)MagnesiumExtrasConfig.zoomScrolling.get()).setImpact(OptionImpact.LOW).build();
        OptionImpl zoomOverlay = OptionImpl.createBuilder(Boolean.class, (OptionStorage)sodiumOpts).setName("Zoom Overlay").setTooltip("Renders a vignette overlay when zooming.").setControl(TickBoxControl::new).setBinding((options, value) -> MagnesiumExtrasConfig.zoomOverlay.set(value), options -> (Boolean)MagnesiumExtrasConfig.zoomOverlay.get()).setImpact(OptionImpact.LOW).build();
        groups.add(OptionGroup.createBuilder().add((Option)zoomScrolling).add((Option)zoomOverlay).build());
        OptionImpl zoomTransition = OptionImpl.createBuilder(MagnesiumExtrasConfig.ZoomTransitionOptions.class, (OptionStorage)sodiumOpts).setName("Zoom Transition Mode").setTooltip("Controls how the game changes from normal to zoomed. Off will be an instant transition.").setControl(option -> new CyclingControl((Option)option, MagnesiumExtrasConfig.ZoomTransitionOptions.class, new String[]{"Off", "Smooth"})).setBinding((opts, value) -> MagnesiumExtrasConfig.zoomTransition.set((Object)value.toString()), opts -> MagnesiumExtrasConfig.ZoomTransitionOptions.valueOf((String)MagnesiumExtrasConfig.zoomTransition.get())).setImpact(OptionImpact.LOW).build();
        OptionImpl zoomMode = OptionImpl.createBuilder(MagnesiumExtrasConfig.ZoomModes.class, (OptionStorage)sodiumOpts).setName("Zoom Keybind Mode").setTooltip("Hold - Zoom only while the key is down.\nToggle - Lock zoom until you press the key again\nPersistent - Always zoom, if you want that, for some reason.").setControl(option -> new CyclingControl((Option)option, MagnesiumExtrasConfig.ZoomModes.class, new String[]{"Hold", "Toggle", "Persistent"})).setBinding((opts, value) -> MagnesiumExtrasConfig.zoomMode.set((Object)value.toString()), opts -> MagnesiumExtrasConfig.ZoomModes.valueOf((String)MagnesiumExtrasConfig.zoomMode.get())).setImpact(OptionImpact.LOW).build();
        groups.add(OptionGroup.createBuilder().add((Option)zoomTransition).add((Option)zoomMode).build());
        this.pages.add(new OptionPage("Zoom", ImmutableList.copyOf(groups)));
    }
}

