/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.mixins;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.map.CustomDecoration;
import net.mehvahdjukaar.selene.map.CustomDecorationHolder;
import net.mehvahdjukaar.selene.map.CustomDecorationType;
import net.mehvahdjukaar.selene.map.MapDecorationHandler;
import net.mehvahdjukaar.selene.map.markers.DummyMapWorldMarker;
import net.mehvahdjukaar.selene.map.markers.MapWorldMarker;
import net.mehvahdjukaar.selene.network.NetworkHandler;
import net.mehvahdjukaar.selene.network.SyncCustomMapDecorationPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SMapDataPacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapBanner;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.network.PacketDistributor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MapData.class})
public abstract class MapDataMixin
extends WorldSavedData
implements CustomDecorationHolder {
    @Shadow
    public int field_76201_a;
    @Shadow
    public int field_76199_b;
    @Shadow
    public byte field_76197_d;
    @Final
    @Shadow
    public Map<String, MapDecoration> field_76203_h;
    @Shadow
    public RegistryKey<World> field_76200_c;
    @Shadow
    public byte[] field_76198_e;
    @Shadow
    public boolean field_215161_h;
    @Shadow
    @Final
    private Map<String, MapBanner> field_204270_k;
    @Final
    public Map<String, CustomDecoration> customDecorations = Maps.newLinkedHashMap();
    @Final
    private Map<String, MapWorldMarker<?>> customMapMarkers = Maps.newHashMap();

    public MapDataMixin(String name) {
        super(name);
    }

    @Override
    public Map<String, CustomDecoration> getCustomDecorations() {
        return this.customDecorations;
    }

    @Override
    public Map<String, MapWorldMarker<?>> getCustomMarkers() {
        return this.customMapMarkers;
    }

    private <D extends CustomDecoration> void addCustomDecoration(MapWorldMarker<D> marker) {
        D decoration = marker.createDecorationFromMarker(this.field_76197_d, this.field_76201_a, this.field_76199_b, this.field_76200_c, this.field_215161_h);
        if (decoration != null) {
            this.customDecorations.put(marker.getMarkerId(), (CustomDecoration)decoration);
        }
    }

    @Inject(method={"lockData"}, at={@At(value="HEAD")}, cancellable=true)
    public void lockData(MapData data, CallbackInfo ci) {
        if (data instanceof CustomDecorationHolder) {
            this.customMapMarkers.putAll(((CustomDecorationHolder)data).getCustomMarkers());
            this.customDecorations.putAll(((CustomDecorationHolder)data).getCustomDecorations());
        }
    }

    @Inject(method={"tickCarriedBy"}, at={@At(value="TAIL")}, cancellable=true)
    public void tickCarriedBy(PlayerEntity player, ItemStack stack, CallbackInfo ci) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("CustomDecorations", 9)) {
            ListNBT listnbt = compoundnbt.func_150295_c("CustomDecorations", 10);
            for (int j = 0; j < listnbt.size(); ++j) {
                CompoundNBT com = listnbt.func_150305_b(j);
                if (this.field_76203_h.containsKey(com.func_74779_i("id"))) continue;
                String name = com.func_74779_i("type");
                CustomDecorationType<?, ?> type = MapDecorationHandler.get(name);
                if (type != null) {
                    DummyMapWorldMarker dummy = new DummyMapWorldMarker(type, com.func_74762_e("x"), com.func_74762_e("z"));
                    this.addCustomDecoration(dummy);
                    continue;
                }
                Selene.LOGGER.warn("Failed to load map decoration " + name + ". Skipping it");
            }
        }
    }

    @Inject(method={"load"}, at={@At(value="TAIL")}, cancellable=true)
    public void load(CompoundNBT compound, CallbackInfo ci) {
        if (compound.func_74764_b("customMarkers")) {
            ListNBT listNBT = compound.func_150295_c("customMarkers", 10);
            for (int j = 0; j < listNBT.size(); ++j) {
                MapWorldMarker<?> marker = MapDecorationHandler.readWorldMarker(listNBT.func_150305_b(j));
                if (marker == null) continue;
                this.customMapMarkers.put(marker.getMarkerId(), marker);
                this.addCustomDecoration(marker);
            }
        }
    }

    @Inject(method={"save"}, at={@At(value="RETURN")}, cancellable=true)
    public void save(CompoundNBT p_189551_1_, CallbackInfoReturnable<CompoundNBT> cir) {
        CompoundNBT com = (CompoundNBT)cir.getReturnValue();
        ListNBT listNBT = new ListNBT();
        for (MapWorldMarker<?> marker : this.customMapMarkers.values()) {
            CompoundNBT com2 = new CompoundNBT();
            com2.func_218657_a(marker.getTypeId(), (INBT)marker.saveToNBT(new CompoundNBT()));
            listNBT.add((Object)com2);
        }
        com.func_218657_a("customMarkers", (INBT)listNBT);
    }

    @Override
    public void resetCustomDecoration() {
        for (String key : this.customMapMarkers.keySet()) {
            this.customDecorations.remove(key);
            this.customMapMarkers.remove(key);
        }
        for (String key : this.field_204270_k.keySet()) {
            this.field_204270_k.remove(key);
            this.field_76203_h.remove(key);
        }
    }

    @Override
    public void toggleCustomDecoration(IWorld world, BlockPos pos) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177952_p() + 0.5;
        int i = 1 << this.field_76197_d;
        double d2 = (d0 - (double)this.field_76201_a) / (double)i;
        double d3 = (d1 - (double)this.field_76199_b) / (double)i;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            List<MapWorldMarker<?>> markers = MapDecorationHandler.getMarkersFromWorld((IBlockReader)world, pos);
            boolean changed = false;
            for (MapWorldMarker<?> marker : markers) {
                if (marker == null) continue;
                String id = marker.getMarkerId();
                if (this.customMapMarkers.containsKey(id) && this.customMapMarkers.get(id).equals(marker)) {
                    this.customMapMarkers.remove(id);
                    this.customDecorations.remove(id);
                } else {
                    this.customMapMarkers.put(id, marker);
                    this.addCustomDecoration(marker);
                }
                changed = true;
            }
            if (changed) {
                this.func_76185_a();
            }
        }
    }

    @Inject(method={"checkBanners"}, at={@At(value="TAIL")}, cancellable=true)
    public void checkBanners(IBlockReader world, int x, int z, CallbackInfo ci) {
        Iterator<MapWorldMarker<?>> iterator = this.customMapMarkers.values().iterator();
        while (iterator.hasNext()) {
            MapWorldMarker<?> marker = iterator.next();
            if (marker.getPos().func_177958_n() != x || marker.getPos().func_177952_p() != z) continue;
            Object newMarker = marker.getType().getWorldMarkerFromWorld(world, marker.getPos());
            String id = marker.getMarkerId();
            if (newMarker == null) {
                iterator.remove();
                this.customDecorations.remove(id);
                continue;
            }
            if (!Objects.equals(id, ((MapWorldMarker)newMarker).getMarkerId()) || !marker.shouldUpdate((MapWorldMarker<?>)newMarker)) continue;
            ((MapWorldMarker)newMarker).updateDecoration(this.customDecorations.get(id));
        }
    }

    @Inject(method={"getUpdatePacket"}, at={@At(value="RETURN")}, cancellable=true)
    public void getUpdatePacket(ItemStack stack, IBlockReader reader, PlayerEntity playerEntity, CallbackInfoReturnable<IPacket<?>> cir) {
        IPacket packet = (IPacket)cir.getReturnValue();
        if (playerEntity instanceof ServerPlayerEntity && packet instanceof SMapDataPacket) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)playerEntity), (Object)new SyncCustomMapDecorationPacket(FilledMapItem.func_195949_f((ItemStack)stack), this.customDecorations.values().toArray(new CustomDecoration[0])));
        }
    }
}

