/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.loot.modification.modifiers;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minecraftabnormals.abnormals_core.common.loot.modification.modifiers.ILootModifier;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.loot.LootTable;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class LootPoolsModifier
implements ILootModifier<Config> {
    public static final Field POOLS = ObfuscationReflectionHelper.findField(LootTable.class, (String)"field_186466_c");

    @Override
    public void modify(LootTableLoadEvent event, Config config) {
        try {
            if (config.replace) {
                POOLS.set(event.getTable(), config.pools);
            } else {
                ((List)POOLS.get(event.getTable())).addAll(config.pools);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public JsonElement serialize(Config config, Gson gson) throws JsonParseException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("replace", Boolean.valueOf(config.replace));
        JsonArray pools = new JsonArray();
        for (LootPool pool : config.pools) {
            pools.add(gson.toJsonTree((Object)pool));
        }
        jsonObject.add("pools", (JsonElement)pools);
        return jsonObject;
    }

    @Override
    public Config deserialize(JsonElement element, Pair<Gson, LootPredicateManager> additional) throws JsonParseException {
        JsonObject jsonObject = element.getAsJsonObject();
        ArrayList<LootPool> lootPools = new ArrayList<LootPool>();
        JsonArray poolsArray = jsonObject.getAsJsonArray("pools");
        Gson gson = (Gson)additional.getFirst();
        poolsArray.forEach(entry -> lootPools.add((LootPool)gson.fromJson(entry, LootPool.class)));
        return new Config(lootPools, jsonObject.get("replace").getAsBoolean());
    }

    public static class Config {
        private final List<LootPool> pools;
        private final boolean replace;

        public Config(List<LootPool> pools, boolean replace) {
            this.pools = pools;
            this.replace = replace;
        }
    }
}

