/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.world.modification;

import com.google.common.collect.Sets;
import com.minecraftabnormals.abnormals_core.common.world.modification.BiomeModificationContext;
import com.minecraftabnormals.abnormals_core.common.world.modification.BiomeModifier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;

public final class BiomeSpawnsModifier
extends BiomeModifier {
    public static final Set<EntityClassification> ALL_CLASSIFICATIONS = Sets.newHashSet((Object[])EntityClassification.values());

    private BiomeSpawnsModifier(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, Consumer<BiomeModificationContext> modifier) {
        super(shouldModify, modifier);
    }

    public static BiomeSpawnsModifier createSpawnCost(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, Supplier<EntityType<?>> typeSupplier, double spawnCostPerEntity, double maxSpawnCost) {
        return new BiomeSpawnsModifier(shouldModify, context -> context.event.getSpawns().func_242573_a((EntityType)typeSupplier.get(), spawnCostPerEntity, maxSpawnCost));
    }

    public static BiomeSpawnsModifier createSpawnAdder(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, EntityClassification classification, Supplier<EntityType<?>> typeSupplier, int weight, int minCount, int maxCount) {
        return new BiomeSpawnsModifier(shouldModify, context -> context.event.getSpawns().func_242575_a(classification, new MobSpawnInfo.Spawners((EntityType)typeSupplier.get(), weight, minCount, maxCount)));
    }

    public static BiomeSpawnsModifier createMultiSpawnAdder(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, EntityClassification classification, Set<SpawnInfo> spawnInfoSet) {
        return new BiomeSpawnsModifier(shouldModify, context -> {
            MobSpawnInfoBuilder builder = context.event.getSpawns();
            for (SpawnInfo spawnInfo : spawnInfoSet) {
                builder.func_242575_a(classification, new MobSpawnInfo.Spawners((EntityType)spawnInfo.type.get(), spawnInfo.weight, spawnInfo.minCount, spawnInfo.maxCount));
            }
        });
    }

    public static BiomeSpawnsModifier createMultiSpawnAdder(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, Set<EntityClassification> classifications, Set<SpawnInfo> spawnInfoSet) {
        return new BiomeSpawnsModifier(shouldModify, context -> {
            MobSpawnInfoBuilder builder = context.event.getSpawns();
            for (EntityClassification classification : classifications) {
                for (SpawnInfo spawnInfo : spawnInfoSet) {
                    builder.func_242575_a(classification, new MobSpawnInfo.Spawners((EntityType)spawnInfo.type.get(), spawnInfo.weight, spawnInfo.minCount, spawnInfo.maxCount));
                }
            }
        });
    }

    public static BiomeSpawnsModifier createSpawnRemover(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, EntityClassification classification, Supplier<EntityType<?>> typeSupplier) {
        return new BiomeSpawnsModifier(shouldModify, context -> context.event.getSpawns().func_242575_a(classification, new MobSpawnInfo.Spawners((EntityType)typeSupplier.get(), 0, 0, 0)));
    }

    public static BiomeSpawnsModifier createMultiSpawnRemover(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, EntityClassification classification, Set<Supplier<EntityType<?>>> typeSuppliers) {
        return new BiomeSpawnsModifier(shouldModify, context -> {
            HashSet entityTypes = Sets.newHashSet();
            typeSuppliers.forEach(typeSupplier -> entityTypes.add(typeSupplier.get()));
            ((List)context.event.getSpawns().field_242567_a.get(classification)).removeIf(info -> entityTypes.contains(info.field_242588_c));
        });
    }

    public static BiomeSpawnsModifier createMultiSpawnRemover(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, Set<EntityClassification> classifications, Set<Supplier<EntityType<?>>> typeSuppliers) {
        return new BiomeSpawnsModifier(shouldModify, context -> {
            HashSet entityTypes = Sets.newHashSet();
            typeSuppliers.forEach(typeSupplier -> entityTypes.add(typeSupplier.get()));
            for (EntityClassification classification : classifications) {
                ((List)context.event.getSpawns().field_242567_a.get(classification)).removeIf(info -> entityTypes.contains(info.field_242588_c));
            }
        });
    }

    public static BiomeSpawnsModifier createSpawnReplacer(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, EntityClassification classification, Supplier<EntityType<?>> replace, Supplier<EntityType<?>> replacer) {
        return new BiomeSpawnsModifier(shouldModify, context -> {
            MobSpawnInfoBuilder builder = context.event.getSpawns();
            EntityType replaceType = (EntityType)replace.get();
            HashSet toRemove = Sets.newHashSet();
            List spawners = (List)builder.field_242567_a.get(classification);
            for (MobSpawnInfo.Spawners spawner2 : spawners) {
                if (spawner2.field_242588_c != replaceType) continue;
                toRemove.add(spawner2);
            }
            EntityType replacerType = (EntityType)replacer.get();
            toRemove.forEach(spawner -> {
                spawners.remove(spawner);
                spawners.add(new MobSpawnInfo.Spawners(replacerType, spawner.field_76292_a, spawner.field_242589_d, spawner.field_242590_e));
            });
        });
    }

    public static BiomeSpawnsModifier createMultiSpawnReplacer(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, Set<EntityClassification> classifications, Supplier<EntityType<?>> replace, Supplier<EntityType<?>> replacer) {
        return new BiomeSpawnsModifier(shouldModify, context -> {
            MobSpawnInfoBuilder builder = context.event.getSpawns();
            EntityType replaceType = (EntityType)replace.get();
            EntityType replacerType = (EntityType)replacer.get();
            for (EntityClassification classification : classifications) {
                HashSet toRemove = Sets.newHashSet();
                List spawners = (List)builder.field_242567_a.get(classification);
                for (MobSpawnInfo.Spawners spawner2 : spawners) {
                    if (spawner2.field_242588_c != replaceType) continue;
                    toRemove.add(spawner2);
                }
                toRemove.forEach(spawner -> {
                    spawners.remove(spawner);
                    spawners.add(new MobSpawnInfo.Spawners(replacerType, spawner.field_76292_a, spawner.field_242589_d, spawner.field_242590_e));
                });
            }
        });
    }

    public static final class SpawnInfo {
        private final Supplier<? extends EntityType<?>> type;
        private final int weight;
        private final int minCount;
        private final int maxCount;

        public SpawnInfo(Supplier<? extends EntityType<?>> type, int weight, int minCount, int maxCount) {
            this.type = type;
            this.weight = weight;
            this.minCount = minCount;
            this.maxCount = maxCount;
        }
    }
}

