/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.api.conditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public final class ACAndRecipeCondition
implements ICondition {
    private final ResourceLocation location;
    private final List<ICondition> children;

    public ACAndRecipeCondition(ResourceLocation location, List<ICondition> children) {
        this.location = location;
        this.children = children;
    }

    public ResourceLocation getID() {
        return this.location;
    }

    public boolean test() {
        return !this.children.isEmpty();
    }

    public static class Serializer
    implements IConditionSerializer<ACAndRecipeCondition> {
        private final ResourceLocation location = new ResourceLocation("abnormals_core", "and");

        public void write(JsonObject json, ACAndRecipeCondition value) {
            JsonArray values = new JsonArray();
            for (ICondition child : value.children) {
                values.add((JsonElement)CraftingHelper.serialize((ICondition)child));
            }
            json.add("values", (JsonElement)values);
        }

        public ACAndRecipeCondition read(JsonObject json) {
            ArrayList<ICondition> children = new ArrayList<ICondition>();
            for (JsonElement elements : JSONUtils.func_151214_t((JsonObject)json, (String)"values")) {
                if (!elements.isJsonObject()) {
                    throw new JsonSyntaxException("And condition values must be an array of JsonObjects");
                }
                ICondition condition = CraftingHelper.getCondition((JsonObject)elements.getAsJsonObject());
                if (!condition.test()) {
                    children.clear();
                    break;
                }
                children.add(condition);
            }
            return new ACAndRecipeCondition(this.location, children);
        }

        public ResourceLocation getID() {
            return this.location;
        }
    }
}

