/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.mixin;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.IDataManager;
import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.SyncType;
import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.TrackedData;
import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.TrackedDataManager;
import com.minecraftabnormals.abnormals_core.core.AbnormalsCore;
import com.minecraftabnormals.abnormals_core.core.events.EntityWalkEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public final class EntityMixin
implements IDataManager {
    @Shadow
    private World field_70170_p;
    private Map<TrackedData<?>, IDataManager.DataEntry<?>> dataMap = Maps.newHashMap();
    private boolean dirty = false;

    @Override
    public <T> void setValue(TrackedData<T> trackedData, T value) {
        IDataManager.DataEntry entry = this.dataMap.computeIfAbsent(trackedData, IDataManager.DataEntry::new);
        if (!entry.getValue().equals(value)) {
            boolean dirty = !this.field_70170_p.field_72995_K && entry.getTrackedData().getSyncType() != SyncType.NOPE;
            entry.setValue(value, dirty);
            this.dirty = dirty;
        }
    }

    @Override
    public <T> T getValue(TrackedData<T> trackedData) {
        return this.dataMap.computeIfAbsent(trackedData, IDataManager.DataEntry::new).getValue();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void clean() {
        this.dataMap.values().forEach(IDataManager.DataEntry::clean);
        this.dirty = false;
    }

    @Override
    public void setDataMap(Map<TrackedData<?>, IDataManager.DataEntry<?>> dataMap) {
        this.dirty = true;
        this.dataMap = dataMap;
    }

    @Override
    public Map<TrackedData<?>, IDataManager.DataEntry<?>> getDataMap() {
        return this.dataMap;
    }

    @Override
    public Set<IDataManager.DataEntry<?>> getDirtyEntries() {
        HashSet dirtyEntries = Sets.newHashSet();
        for (IDataManager.DataEntry<?> entry : this.dataMap.values()) {
            if (!entry.isDirty() || entry.getTrackedData().getSyncType() == SyncType.NOPE) continue;
            dirtyEntries.add(entry);
        }
        return dirtyEntries;
    }

    @Override
    public Set<IDataManager.DataEntry<?>> getEntries(boolean syncToAll) {
        HashSet dirtyEntries = Sets.newHashSet();
        for (IDataManager.DataEntry<?> entry : this.dataMap.values()) {
            SyncType syncType = entry.getTrackedData().getSyncType();
            if (!(syncToAll ? syncType == SyncType.TO_CLIENTS : syncType != SyncType.NOPE)) continue;
            dirtyEntries.add(entry);
        }
        return dirtyEntries;
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundNBT;)V", shift=At.Shift.BEFORE)}, method={"saveWithoutId"})
    private void writeTrackedData(CompoundNBT compound, CallbackInfoReturnable<CompoundNBT> info) {
        if (!this.dataMap.isEmpty()) {
            ListNBT dataListTag = new ListNBT();
            this.dataMap.forEach((trackedData, dataEntry) -> {
                if (trackedData.shouldSave()) {
                    CompoundNBT dataTag = dataEntry.writeValue();
                    dataTag.func_74778_a("Id", TrackedDataManager.INSTANCE.getKey((TrackedData<?>)trackedData).toString());
                    dataListTag.add((Object)dataTag);
                }
            });
            compound.func_218657_a("ACTrackedData", (INBT)dataListTag);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundNBT;)V", shift=At.Shift.BEFORE)}, method={"load"})
    public void read(CompoundNBT compound, CallbackInfo info) {
        if (compound.func_150297_b("ACTrackedData", 9)) {
            ListNBT dataListTag = compound.func_150295_c("ACTrackedData", 10);
            dataListTag.forEach(nbt -> {
                CompoundNBT dataTag = (CompoundNBT)nbt;
                ResourceLocation id = new ResourceLocation(dataTag.func_74779_i("Id"));
                TrackedData<?> trackedData = TrackedDataManager.INSTANCE.getTrackedData(id);
                if (trackedData != null && trackedData.shouldSave()) {
                    IDataManager.DataEntry dataEntry = new IDataManager.DataEntry(trackedData);
                    dataEntry.readValue(dataTag, true);
                    this.dataMap.put(trackedData, dataEntry);
                } else if (trackedData == null) {
                    AbnormalsCore.LOGGER.warn("Received NBT for unknown Tracked Data: {}", (Object)id);
                }
            });
        }
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;stepOn(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;)V"))
    private void onEntityWalk(Block block, World world, BlockPos pos, Entity entity) {
        if (!EntityWalkEvent.onEntityWalk(world, pos, entity)) {
            block.func_176199_a(world, pos, entity);
        }
    }
}

