/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util.modification;

import com.google.gson.Gson;
import com.minecraftabnormals.abnormals_core.core.util.modification.ConfiguredModifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.util.ResourceLocation;

public abstract class ModificationManager<T, S, D>
extends JsonReloadListener {
    private final Map<ResourceLocation, List<ConfiguredModifier<T, ?, S, D, ?>>> modifiers = new HashMap();

    public ModificationManager(Gson gson, String string) {
        super(gson, string);
    }

    public List<ConfiguredModifier<T, ?, S, D, ?>> putModifiers(ResourceLocation target, List<ConfiguredModifier<T, ?, S, D, ?>> configuredModifiers) {
        return this.modifiers.put(target, configuredModifiers);
    }

    public boolean addModifier(ResourceLocation target, ConfiguredModifier<T, ?, S, D, ?> configuredModifier) {
        return this.modifiers.computeIfAbsent(target, location -> new ArrayList()).add(configuredModifier);
    }

    public boolean addModifiers(ResourceLocation target, List<ConfiguredModifier<T, ?, S, D, ?>> configuredModifiers) {
        return this.modifiers.computeIfAbsent(target, location -> new ArrayList()).addAll(configuredModifiers);
    }

    @Nullable
    public List<ConfiguredModifier<T, ?, S, D, ?>> getModifiers(ResourceLocation resourceLocation) {
        return this.modifiers.get(resourceLocation);
    }

    public int size() {
        return this.modifiers.size();
    }

    public void reset() {
        this.modifiers.clear();
    }
}

