/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.lib.sonar.sonar.client.framebuffer;

import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.client.framebuffer.AdvancedFboAttachment;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.lwjgl.opengl.GL30;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedFboAttachmentDepthRenderBuffer
implements AdvancedFboAttachment {
    private int id = -1;
    private final int width;
    private final int height;
    private final int samples;

    public AdvancedFboAttachmentDepthRenderBuffer(int width, int height, int samples) {
        this.width = width;
        this.height = height;
        Validate.inclusiveBetween((long)1L, (long)GL30.glGetInteger((int)36183), (long)samples);
        this.samples = samples;
    }

    private void createRaw() {
        this.bind();
        if (this.samples == 1) {
            GL30.glRenderbufferStorage((int)36161, (int)33190, (int)this.width, (int)this.height);
        } else {
            GL30.glRenderbufferStorageMultisample((int)36161, (int)this.samples, (int)33190, (int)this.width, (int)this.height);
        }
        this.unbind();
    }

    private int getId() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (this.id == -1) {
            this.id = GL30.glGenRenderbuffers();
        }
        return this.id;
    }

    @Override
    public void create() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::createRaw);
        } else {
            this.createRaw();
        }
    }

    @Override
    public void attach(int target, int attachment) {
        Validate.isTrue((attachment == 0 ? 1 : 0) != 0, (String)"Only one depth buffer attachment is supported.", (Object[])new Object[0]);
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glFramebufferRenderbuffer((int)target, (int)36096, (int)36161, (int)this.getId()));
        } else {
            GL30.glFramebufferRenderbuffer((int)target, (int)36096, (int)36161, (int)this.getId());
        }
    }

    @Override
    public void bind() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindRenderbuffer((int)36161, (int)this.getId()));
        } else {
            GL30.glBindRenderbuffer((int)36161, (int)this.getId());
        }
    }

    @Override
    public void unbind() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindRenderbuffer((int)36161, (int)0));
        } else {
            GL30.glBindRenderbuffer((int)36161, (int)0);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getSamples() {
        return this.samples;
    }

    @Override
    public boolean canSample() {
        return false;
    }

    @Override
    public AdvancedFboAttachment createCopy() {
        return new AdvancedFboAttachmentDepthRenderBuffer(this.width, this.height, this.samples);
    }

    public void free() {
        if (this.id == -1) {
            return;
        }
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                GL30.glDeleteRenderbuffers((int)this.id);
                this.id = -1;
            });
        } else {
            GL30.glDeleteRenderbuffers((int)this.id);
            this.id = -1;
        }
    }
}

