/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.client.event;

import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lehjr.numina.client.gui.gemoetry.DrawableRelativeRect;
import lehjr.numina.client.render.NuminaRenderer;
import lehjr.numina.common.capabilities.inventory.modechanging.IModeChangingItem;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.common.capabilities.render.highlight.HighLightCapability;
import lehjr.numina.common.math.Colour;
import lehjr.numina.common.string.StringUtils;
import lehjr.powersuits.client.control.KeybindManager;
import lehjr.powersuits.client.control.MPSKeyBinding;
import lehjr.powersuits.client.model.helper.MPSModelHelper;
import lehjr.powersuits.common.config.MPSSettings;
import lehjr.powersuits.common.constants.MPSRegistryNames;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public enum RenderEventHandler {
    INSTANCE;

    private static boolean ownFly;
    private final DrawableRelativeRect frame = new DrawableRelativeRect((double)MPSSettings.getHudKeybindX(), (double)MPSSettings.getHudKeybindY(), (double)(MPSSettings.getHudKeybindX() + 16.0f), (double)(MPSSettings.getHudKeybindY() + 16.0f), true, Colour.DARK_GREEN.withAlpha(0.2f), Colour.GREEN.withAlpha(0.2f));
    final List<KBDisplay> kbDisplayList = new ArrayList<KBDisplay>();

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderBlockHighlight(DrawHighlightEvent event) {
        if (event.getTarget().func_216346_c() != RayTraceResult.Type.BLOCK || !(event.getInfo().func_216773_g() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getInfo().func_216773_g();
        player.func_184614_ca().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).ifPresent(iModeChangingItem -> iModeChangingItem.getActiveModule().getCapability(HighLightCapability.HIGHLIGHT).ifPresent(iHighlight -> {
            BlockRayTraceResult result = (BlockRayTraceResult)event.getTarget();
            NonNullList blocks = iHighlight.getBlockPositions(result);
            if (blocks.isEmpty()) {
                return;
            }
            MatrixStack matrixStack = event.getMatrix();
            IRenderTypeBuffer buffer = event.getBuffers();
            IVertexBuilder lineBuilder = buffer.getBuffer((RenderType)RenderType.field_228614_Q_);
            double partialTicks = event.getPartialTicks();
            double x = player.field_70142_S + (player.func_226277_ct_() - player.field_70142_S) * partialTicks;
            double y = player.field_70137_T + (double)player.func_70047_e() + (player.func_226278_cu_() - player.field_70137_T) * partialTicks;
            double z = player.field_70136_U + (player.func_226281_cx_() - player.field_70136_U) * partialTicks;
            matrixStack.func_227860_a_();
            blocks.forEach(blockPos -> {
                AxisAlignedBB aabb = new AxisAlignedBB(blockPos).func_72317_d(-x, -y, -z);
                WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)lineBuilder, (AxisAlignedBB)aabb, (float)(blockPos.equals((Object)result.func_216350_a()) ? 1.0f : 0.0f), (float)0.0f, (float)0.0f, (float)0.4f);
            });
            matrixStack.func_227865_b_();
            event.setCanceled(true);
        }));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void preTextureStitch(TextureStitchEvent.Pre event) {
        MPSModelHelper.loadArmorModels(event, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Post event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPostRenderGameOverlayEvent(RenderGameOverlayEvent.Post e) {
        RenderGameOverlayEvent.ElementType elementType = e.getType();
        if (RenderGameOverlayEvent.ElementType.HOTBAR.equals((Object)elementType)) {
            this.drawKeybindToggles(e.getMatrixStack());
        }
    }

    @SubscribeEvent
    public void onPreRenderPlayer(RenderPlayerEvent.Pre event) {
        if (!event.getPlayer().field_71075_bZ.field_75100_b && !event.getPlayer().func_233570_aj_() && this.playerHasFlightOn(event.getPlayer())) {
            event.getPlayer().field_71075_bZ.field_75100_b = true;
            ownFly = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean playerHasFlightOn(PlayerEntity player) {
        if (player.func_184582_a(EquipmentSlotType.HEAD).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).map(iModularItem -> iModularItem.isModuleOnline(MPSRegistryNames.FLIGHT_CONTROL_MODULE)).orElse(false) != false) return true;
        if (player.func_184582_a(EquipmentSlotType.CHEST).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).map(iModularItem -> iModularItem.isModuleOnline(MPSRegistryNames.JETPACK_MODULE) || iModularItem.isModuleOnline(MPSRegistryNames.GLIDER_MODULE)).orElse(false) != false) return true;
        if (player.func_184582_a(EquipmentSlotType.FEET).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).map(iModularItem -> iModularItem.isModuleOnline(MPSRegistryNames.JETBOOTS_MODULE)).orElse(false) == false) return false;
        return true;
    }

    @SubscribeEvent
    public void onPostRenderPlayer(RenderPlayerEvent.Post event) {
        if (ownFly) {
            ownFly = false;
            event.getPlayer().field_71075_bZ.field_75100_b = false;
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent e) {
        e.getEntity().func_184582_a(EquipmentSlotType.HEAD).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(h -> {
            ItemStack binnoculars;
            if (h instanceof IModularItem && !(binnoculars = h.getOnlineModuleOrEmpty(MPSRegistryNames.BINOCULARS_MODULE)).func_190926_b()) {
                e.setNewfov((float)((double)e.getNewfov() / binnoculars.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> m.applyPropertyModifiers("fieldOfView")).orElse(1.0)));
            }
        });
    }

    public void makeKBDisplayList() {
        this.kbDisplayList.clear();
        KeybindManager.INSTANCE.getMPSKeyBinds().stream().filter(kb -> !kb.func_197986_j()).filter(kb -> kb.showOnHud).forEach(kb -> {
            Optional<KBDisplay> kbDisplay = this.kbDisplayList.stream().filter(kbd -> kbd.finalId.equals((Object)kb.getKey())).findFirst();
            if (kbDisplay.isPresent()) {
                kbDisplay.map(kbd -> kbd.boundKeybinds.add((MPSKeyBinding)((Object)kb)));
            } else {
                this.kbDisplayList.add(new KBDisplay((MPSKeyBinding)((Object)kb), MPSSettings.getHudKeybindX(), MPSSettings.getHudKeybindY(), MPSSettings.getHudKeybindX() + 16.0f));
            }
        });
    }

    boolean isModularItemEquuiiped() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        return Arrays.stream(EquipmentSlotType.values()).filter(arg_0 -> RenderEventHandler.lambda$isModularItemEquuiiped$13((PlayerEntity)player, arg_0)).findFirst().isPresent();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawKeybindToggles(MatrixStack matrixStack) {
        if (MPSSettings.displayHud() && this.isModularItemEquuiiped()) {
            Minecraft minecraft = Minecraft.func_71410_x();
            AtomicDouble top = new AtomicDouble((double)MPSSettings.getHudKeybindY());
            this.kbDisplayList.forEach(kbDisplay -> {
                if (!kbDisplay.boundKeybinds.isEmpty()) {
                    kbDisplay.setLeft(MPSSettings.getHudKeybindX());
                    kbDisplay.setTop(top.get());
                    kbDisplay.setBottom(top.get() + 16.0);
                    kbDisplay.func_230430_a_(matrixStack, 0, 0, minecraft.func_184121_ak());
                    top.getAndAdd(16.0);
                }
            });
        }
    }

    private static /* synthetic */ boolean lambda$isModularItemEquuiiped$13(PlayerEntity player, EquipmentSlotType type) {
        return player.func_184582_a(type).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).isPresent();
    }

    static {
        ownFly = false;
    }

    class KBDisplay
    extends DrawableRelativeRect {
        List<MPSKeyBinding> boundKeybinds;
        final InputMappings.Input finalId;

        public KBDisplay(MPSKeyBinding kb, double left, double top, double right) {
            super(left, top, right, top + 16.0, true, Colour.DARK_GREEN.withAlpha(0.2f), Colour.GREEN.withAlpha(0.2f));
            this.boundKeybinds = new ArrayList<MPSKeyBinding>();
            this.finalId = kb.getKey();
            this.boundKeybinds.add(kb);
        }

        public ITextComponent getLabel() {
            return this.finalId.func_237520_d_();
        }

        public void addKeyBind(MPSKeyBinding kb) {
            if (!this.boundKeybinds.contains((Object)kb)) {
                this.boundKeybinds.add(kb);
            }
        }

        ClientPlayerEntity getPlayer() {
            return Minecraft.func_71410_x().field_71439_g;
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
            float stringwidth = StringUtils.getFontRenderer().func_238414_a_((ITextProperties)this.getLabel());
            this.setWidth(stringwidth + 8.0f + (float)(this.boundKeybinds.stream().filter(kb -> kb.showOnHud).collect(Collectors.toList()).size() * 18));
            super.func_230430_a_(matrixStack, 0, 0, frameTime);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 100.0);
            boolean kbToggleVal = this.boundKeybinds.stream().filter(kb -> kb.toggleval).findFirst().isPresent();
            StringUtils.drawLeftAlignedText((MatrixStack)matrixStack, (ITextComponent)this.getLabel(), (double)((float)this.left() + 4.0f), (double)((float)this.top() + 9.0f), (Colour)(kbToggleVal ? Colour.RED : Colour.GREEN));
            matrixStack.func_227865_b_();
            AtomicDouble x = new AtomicDouble(this.left() + (double)stringwidth + 8.0);
            this.boundKeybinds.stream().filter(kb -> kb.showOnHud).forEach(kb -> {
                boolean active = false;
                ItemStack module = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(kb.registryName));
                for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                    ItemStack stack = this.getPlayer().func_184582_a(slot);
                    active = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).map(iItemHandler -> {
                        if (iItemHandler instanceof IModeChangingItem) {
                            return ((IModeChangingItem)iItemHandler).isModuleActiveAndOnline(kb.registryName);
                        }
                        return iItemHandler.isModuleOnline(kb.registryName);
                    }).orElse(false);
                    if (active) break;
                }
                NuminaRenderer.drawModuleAt((MatrixStack)matrixStack, (double)x.get(), (double)this.top(), (ItemStack)module, (boolean)active);
                x.getAndAdd(16.0);
            });
        }
    }
}

