/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.client.gui.clickable;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Set;
import java.util.stream.Collectors;
import lehjr.numina.client.gui.clickable.ClickableButton2;
import lehjr.numina.client.gui.clickable.ClickableModule;
import lehjr.numina.client.gui.clickable.IClickable;
import lehjr.numina.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.client.render.NuminaRenderer;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.common.math.Colour;
import lehjr.numina.common.network.NuminaPackets;
import lehjr.numina.common.network.packets.ToggleRequestPacket;
import lehjr.numina.common.string.StringUtils;
import lehjr.powersuits.client.control.KeybindManager;
import lehjr.powersuits.client.control.MPSKeyBinding;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.CapabilityItemHandler;

public class HudKbDisplayBox
extends ClickableButton2 {
    BiMap<MPSKeyBinding, ClickableModule> boundModules = HashBiMap.create();
    public boolean toggleval = false;
    public boolean displayOnHUD = false;
    boolean toggled = false;
    InputMappings.Input key;

    public HudKbDisplayBox(InputMappings.Input keyIn) {
        super(keyIn.func_237520_d_(), MusePoint2D.ZERO, true);
        this.key = keyIn;
    }

    public void doToggleTick() {
        this.doToggleIf(this.boundModules.keySet().stream().filter(mpsKeyBinding -> mpsKeyBinding.func_151468_f()).collect(Collectors.toList()).size() > 0);
    }

    public void doToggleIf(boolean value) {
        if (value && !this.toggled) {
            this.toggleModules();
            KeybindManager.INSTANCE.writeOutKeybindSetings();
        }
        this.toggled = value;
    }

    public void toggleModules() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        for (ClickableModule module : this.boundModules.values()) {
            ResourceLocation registryName = module.getRegName();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                player.field_71071_by.func_70301_a(i).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(handler -> handler.toggleModule(registryName, this.toggleval));
            }
            NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new ToggleRequestPacket(registryName, this.toggleval));
        }
        this.toggleval = !this.toggleval;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        for (ClickableModule module : this.boundModules.values()) {
            NuminaRenderer.drawLineBetween((IClickable)this, (IClickable)module, (Colour)Colour.LIGHT_BLUE, (float)0.0f);
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            matrixStack.func_227861_a_(0.0, 0.0, 100.0);
            if (this.displayOnHUD) {
                StringUtils.drawShadowedString((MatrixStack)matrixStack, (String)StringUtils.wrapFormatTags((String)"HUD", (StringUtils.FormatCodes)StringUtils.FormatCodes.BrightGreen), (double)(this.getPosition().getX() * 2.0 + 6.0), (double)(this.getPosition().getY() * 2.0 + 6.0));
            } else {
                StringUtils.drawShadowedString((MatrixStack)matrixStack, (String)StringUtils.wrapFormatTags((String)"x", (StringUtils.FormatCodes)StringUtils.FormatCodes.Red), (double)(this.getPosition().getX() * 2.0 + 6.0), (double)(this.getPosition().getY() * 2.0 + 6.0));
            }
            matrixStack.func_227865_b_();
        }
    }

    public InputMappings.Input getKeyBinding() {
        return this.key;
    }

    public Set<ClickableModule> getBoundModules() {
        return this.boundModules.values();
    }

    public void bindModule(ClickableModule module, MPSKeyBinding keyBinding) {
        if (!this.boundModules.containsValue((Object)module) && !this.boundModules.containsKey((Object)keyBinding)) {
            this.boundModules.put((Object)keyBinding, (Object)module);
        }
    }

    public void unbindModule(ClickableModule module) {
        this.boundModules.remove((Object)module);
    }

    public void toggleHUDState() {
        this.displayOnHUD = !this.displayOnHUD;
    }

    public boolean equals(HudKbDisplayBox other) {
        return other.key.func_197937_c() == this.key.func_197937_c();
    }
}

