/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.client.gui.modding.module.tweak;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lehjr.numina.client.gui.clickable.ClickableModule;
import lehjr.numina.client.gui.frame.ScrollableFrame;
import lehjr.numina.client.gui.gemoetry.IRect;
import lehjr.numina.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.client.gui.gemoetry.RelativeRect;
import lehjr.numina.client.render.NuminaRenderer;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.common.math.Colour;
import lehjr.powersuits.client.gui.common.ModularItemSelectionFrame;
import lehjr.powersuits.client.gui.modding.module.tweak.ModuleSelectionSubFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.LazyOptional;

public class ModuleSelectionFrame
extends ScrollableFrame {
    protected ModularItemSelectionFrame target;
    protected Map<ModuleCategory, ModuleSelectionSubFrame> categories = new LinkedHashMap<ModuleCategory, ModuleSelectionSubFrame>();
    protected RelativeRect lastPosition;
    Optional<ClickableModule> selectedModule = Optional.ofNullable(null);
    LazyOptional<IPowerModule> moduleCap = LazyOptional.empty();
    OnSelectNewModule doThis;

    public ModuleSelectionFrame(ModularItemSelectionFrame itemSelectFrameIn, MusePoint2D topleft, MusePoint2D bottomright, Colour background, Colour topBorder, Colour bottomBorder) {
        super(topleft, bottomright, background, topBorder, bottomBorder);
        this.target = itemSelectFrameIn;
    }

    protected ModuleSelectionSubFrame getOrCreateCategory(ModuleCategory category) {
        if (this.categories.containsKey(category)) {
            return this.categories.get(category);
        }
        RelativeRect position = new RelativeRect(this.getRect().left() + 4.0, this.getRect().top() + 4.0, this.getRect().right() - 4.0, this.getRect().top() + 36.0);
        position.setMeBelow((IRect)this.lastPosition);
        this.lastPosition = position;
        ModuleSelectionSubFrame frame = new ModuleSelectionSubFrame(category, position);
        this.categories.put(category, frame);
        frame.setDoOnNewSelect((ModuleSelectionSubFrame thing) -> {
            this.selectedModule = Optional.of(thing.getSelectedModule());
            this.moduleCap = this.selectedModule.map(clickableModule -> clickableModule.getModule()).orElse(ItemStack.field_190927_a).getCapability(PowerModuleCapability.POWER_MODULE);
        });
        return frame;
    }

    public void loadModules(boolean preserveSelected) {
        this.lastPosition = null;
        AtomicReference<Optional<ClickableModule>> selCopy = new AtomicReference<Optional<ClickableModule>>(this.getSelectedModule());
        AtomicBoolean preserve = new AtomicBoolean(preserveSelected);
        this.categories.clear();
        this.target.getModularItemCapability().ifPresent(iModularItem -> {
            if (!preserve.get()) {
                selCopy.set(Optional.empty());
            } else if (this.getSelectedModule().isPresent()) {
                this.getSelectedModule().ifPresent(sm -> selCopy.set(Optional.of(new ClickableModule(sm.getModule(), new MusePoint2D(0.0, 0.0), -1, sm.category))));
            }
            int index = 0;
            while (index < iModularItem.getSlots()) {
                ItemStack module = iModularItem.getStackInSlot(index);
                int finalIndex = index++;
                module.getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(m -> {
                    if (m.isAllowed()) {
                        this.getOrCreateCategory(m.getCategory()).addModule(module, finalIndex);
                    }
                });
            }
        });
        block0: for (ModuleSelectionSubFrame frame : this.categories.values()) {
            frame.refreshButtonPositions();
            if (!preserveSelected || !selCopy.get().isPresent() || frame.category != selCopy.get().get().category) continue;
            for (ClickableModule button : frame.moduleButtons) {
                if (!button.getModule().func_77969_a(selCopy.get().get().getModule())) continue;
                frame.selectedModule = frame.moduleButtons.indexOf(button);
                preserveSelected = false;
                continue block0;
            }
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        Optional<IModularItem> iModularItem = this.target.getModularItemCapability();
        this.categories.values().forEach(frame -> frame.refreshButtonPositions());
        if (iModularItem.isPresent()) {
            this.totalSize = 0;
            for (ModuleSelectionSubFrame frame2 : this.categories.values()) {
                this.totalSize = (int)Math.max(frame2.border.bottom() - this.getRect().top(), (double)this.totalSize);
            }
            this.currentScrollPixels = Math.min(this.currentScrollPixels, this.getMaxScrollPixels());
            super.preRender(matrixStack, mouseX, mouseY, partialTicks);
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)(-this.currentScrollPixels), (float)0.0f);
            this.drawItems(matrixStack, partialTicks);
            this.drawSelection(matrixStack);
            RenderSystem.popMatrix();
            super.postRender(mouseX, mouseY, partialTicks);
        } else {
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    private void drawItems(MatrixStack matrixStack, float partialTicks) {
        for (ModuleSelectionSubFrame frame : this.categories.values()) {
            frame.drawPartial(matrixStack, (int)((double)this.currentScrollPixels + this.getRect().top() + 4.0), (int)((double)this.currentScrollPixels + this.getRect().top() + this.getRect().height() - 4.0), partialTicks);
        }
    }

    float getzLevel() {
        return Minecraft.func_71410_x().field_71462_r.func_230927_p_();
    }

    private void drawSelection(MatrixStack matrixStack) {
        this.getSelectedModule().ifPresent(module -> {
            MusePoint2D pos = module.getPosition();
            if (pos.getY() > (double)this.currentScrollPixels + this.getRect().top() + 4.0 && pos.getY() < (double)this.currentScrollPixels + this.getRect().top() + this.getRect().height() - 4.0) {
                NuminaRenderer.drawCircleAround((MatrixStack)matrixStack, (double)pos.getX(), (double)pos.getY(), (double)10.0, (float)this.getzLevel());
            }
        });
    }

    public Optional<ClickableModule> getSelectedModule() {
        return this.selectedModule;
    }

    public LazyOptional<IPowerModule> getModuleCap() {
        return this.moduleCap;
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (super.mouseClicked(x, y, button)) {
            ModuleSelectionSubFrame sel = null;
            if (this.getRect().containsPoint(x, y)) {
                y += (double)this.currentScrollPixels;
                for (ModuleSelectionSubFrame frame : this.categories.values()) {
                    if (!frame.mouseClicked(x, y, button)) continue;
                    sel = frame;
                }
                if (sel != null && sel.getSelectedModule() != null) {
                    for (ModuleSelectionSubFrame frame : this.categories.values()) {
                        if (frame == sel) continue;
                        frame.resetSelection();
                    }
                }
            }
            return sel != null;
        }
        return false;
    }

    public List<ITextComponent> getToolTip(int x, int y) {
        if (this.getRect().containsPoint((double)x, (double)y)) {
            y += this.currentScrollPixels;
            if (!this.categories.isEmpty()) {
                for (ModuleSelectionSubFrame category : this.categories.values()) {
                    List<ITextComponent> tooltip = category.getToolTip(x, y);
                    if (tooltip == null) continue;
                    return tooltip;
                }
            }
        }
        return null;
    }

    public void setDoOnNewSelect(OnSelectNewModule doThisIn) {
        this.doThis = doThisIn;
    }

    void onSelected() {
        if (this.doThis != null) {
            this.doThis.onSelected(this);
        }
    }

    public static interface OnSelectNewModule {
        public void onSelected(ModuleSelectionFrame var1);
    }
}

