/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.client.gui.modding.module.tweak;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import lehjr.numina.client.gui.clickable.ClickableModule;
import lehjr.numina.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.client.gui.gemoetry.RelativeRect;
import lehjr.numina.client.sound.Musique;
import lehjr.numina.client.sound.SoundDictionary;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.math.Colour;
import lehjr.numina.common.string.StringUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;

public class ModuleSelectionSubFrame {
    public List<ClickableModule> moduleButtons;
    public int selectedModule = -1;
    int oldSelected = -1;
    protected RelativeRect border;
    public ModuleCategory category;
    OnSelectNewModule doThis;

    public ModuleSelectionSubFrame(ModuleCategory category, RelativeRect border) {
        this.category = category;
        this.border = border;
        this.moduleButtons = new ArrayList<ClickableModule>();
    }

    public ClickableModule addModule(@Nonnull ItemStack module, int index) {
        ClickableModule clickie = new ClickableModule(module, new MusePoint2D(0.0, 0.0), index, this.category);
        this.moduleButtons.add(clickie);
        Collections.sort(this.moduleButtons, Comparator.comparing(ClickableModule::getTier));
        this.refreshButtonPositions();
        return clickie;
    }

    public void drawPartial(MatrixStack matrixStack, int min, int max, float partialTicks) {
        this.refreshButtonPositions();
        StringUtils.drawShadowedString((MatrixStack)matrixStack, (String)this.category.getTranslation().getString(), (double)this.border.left(), (double)this.border.top(), (Colour)Colour.WHITE);
        for (ClickableModule clickie : this.moduleButtons) {
            clickie.func_230430_a_(matrixStack, min, max, partialTicks);
        }
    }

    public void refreshButtonPositions() {
        int col = 0;
        int row = 0;
        int topMargin = 20;
        int leftMargin = 10;
        for (ClickableModule clickie : this.moduleButtons) {
            if (col > 4) {
                col = 0;
                ++row;
            }
            double x = this.border.left() + (double)leftMargin + (double)(20 * col);
            double y = this.border.top() + (double)topMargin + (double)(20 * row);
            clickie.setPosition(new MusePoint2D(x, y));
            ++col;
        }
        this.border.setHeight((double)(topMargin * 2 + 20 * row));
    }

    public ClickableModule getSelectedModule() {
        if (this.selectedModule >= 0) {
            return this.moduleButtons.get(this.selectedModule);
        }
        return null;
    }

    public void resetSelection() {
        this.selectedModule = -1;
        this.oldSelected = -1;
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.border.containsPoint(x, y)) {
            for (ClickableModule module : this.moduleButtons) {
                if (!module.hitBox((double)((float)x), (double)((float)y))) continue;
                Musique.playClientSound((SoundEvent)SoundDictionary.SOUND_EVENT_GUI_SELECT, (float)1.0f);
                this.selectedModule = this.moduleButtons.indexOf(module);
                if (this.selectedModule != this.oldSelected) {
                    this.oldSelected = this.selectedModule;
                    this.onSelected();
                }
                return true;
            }
        }
        return false;
    }

    public List<ITextComponent> getToolTip(int x, int y) {
        if (this.border.containsPoint((double)x, (double)y) && this.moduleButtons != null) {
            for (ClickableModule module : this.moduleButtons) {
                if (!module.hitBox((double)x, (double)y)) continue;
                return module.getToolTip(x, y);
            }
        }
        return null;
    }

    public void setDoOnNewSelect(OnSelectNewModule doThisIn) {
        this.doThis = doThisIn;
    }

    void onSelected() {
        if (this.doThis != null) {
            this.doThis.onSelected(this);
        }
    }

    public static interface OnSelectNewModule {
        public void onSelected(ModuleSelectionSubFrame var1);
    }
}

