/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.item.module.movement;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.client.control.PlayerMovementInputWrapper;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.common.capabilities.module.tickable.PlayerTickModule;
import lehjr.numina.common.player.PlayerUtils;
import lehjr.powersuits.common.config.MPSSettings;
import lehjr.powersuits.common.event.MovementManager;
import lehjr.powersuits.common.item.module.AbstractPowerModule;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class JumpAssistModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final Ticker ticker;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, ModuleCategory.MOVEMENT, ModuleTarget.LEGSONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addSimpleTradeoff("jumpPower", "jumpEnergy", "FE", 0.0, 250.0, "multiplier", "%", 1.0, 4.0);
                    this.addSimpleTradeoff("compensation", "jumpEnergy", "FE", 0.0, 50.0, "sprintExComp", "%", 0.0, 1.0);
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> {
                this.ticker.updateFromNBT();
                return this.ticker;
            });
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, true);
            }

            public void onPlayerTickActive(PlayerEntity player, ItemStack item) {
                PlayerMovementInputWrapper.PlayerMovementInput playerInput = PlayerMovementInputWrapper.get((PlayerEntity)player);
                if (playerInput.jumpKey) {
                    double multiplier = MovementManager.INSTANCE.getPlayerJumpMultiplier(player);
                    if (multiplier > 0.0) {
                        player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, 0.15 * Math.min(multiplier, 1.0), 0.0));
                        MovementManager.INSTANCE.setPlayerJumpTicks(player, multiplier - 1.0);
                    }
                    player.field_70747_aH = player.func_70689_ay() * 0.2f;
                } else {
                    MovementManager.INSTANCE.setPlayerJumpTicks(player, 0.0);
                }
                PlayerUtils.resetFloatKickTicks((PlayerEntity)player);
            }
        }
    }
}

