/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.item.module.special;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.common.capabilities.module.tickable.PlayerTickModule;
import lehjr.numina.common.energy.ElectricItemUtils;
import lehjr.powersuits.common.config.MPSSettings;
import lehjr.powersuits.common.item.module.AbstractPowerModule;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class InvisibilityModule
extends AbstractPowerModule {
    private final Effect invisibility = Effects.field_76441_p;

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final Ticker ticker;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, ModuleCategory.SPECIAL, ModuleTarget.TORSOONLY, MPSSettings::getModuleConfig);
            this.powerModuleHolder = LazyOptional.of(() -> {
                this.ticker.updateFromNBT();
                return this.ticker;
            });
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, false);
            }

            public void onPlayerTickActive(PlayerEntity player, ItemStack item) {
                double totalEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)player);
                EffectInstance invis = null;
                if (player.func_70644_a(InvisibilityModule.this.invisibility)) {
                    invis = player.func_70660_b(InvisibilityModule.this.invisibility);
                }
                if (50.0 < totalEnergy) {
                    if (invis == null || invis.func_76459_b() < 210) {
                        player.func_195064_c(new EffectInstance(InvisibilityModule.this.invisibility, 500, -3, false, false));
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)50);
                    }
                } else {
                    this.onPlayerTickInactive(player, item);
                }
            }

            public void onPlayerTickInactive(PlayerEntity player, ItemStack item) {
                EffectInstance invis = null;
                if (player.func_70644_a(InvisibilityModule.this.invisibility)) {
                    invis = player.func_70660_b(InvisibilityModule.this.invisibility);
                }
                if (invis != null && invis.func_76458_c() == -3) {
                    if (player.field_70170_p.field_72995_K) {
                        player.func_184596_c(InvisibilityModule.this.invisibility);
                    } else {
                        player.func_195063_d(InvisibilityModule.this.invisibility);
                    }
                }
            }
        }
    }
}

