/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.item.module.tool;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.module.blockbreaking.IBlockBreakingModule;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.common.capabilities.module.rightclick.RightClickModule;
import lehjr.numina.common.energy.ElectricItemUtils;
import lehjr.numina.common.helper.ToolHelpers;
import lehjr.powersuits.common.config.MPSSettings;
import lehjr.powersuits.common.item.module.AbstractPowerModule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class HoeModule
extends AbstractPowerModule {
    protected static final Map<Block, BlockState> HOE_LOOKUP = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.field_196658_i, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_185774_da, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_150346_d, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_196660_k, (Object)Blocks.field_150346_d.func_176223_P()));

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final RightClickie rightClickie;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.rightClickie = new RightClickie(module, ModuleCategory.TOOL, ModuleTarget.TOOLONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("hoeEnergy", 500.0, "FE");
                    this.addTradeoffProperty("radius", "hoeEnergy", 9500.0);
                    this.addIntTradeoffProperty("radius", "radius", 8, "m", 1, 0);
                    this.addBaseProperty("hoeHarvestSpeed", 8.0, "x");
                    this.addTradeoffProperty("overclock", "hoeEnergy", 9500.0);
                    this.addTradeoffProperty("overclock", "hoeHarvestSpeed", 22.0);
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> this.rightClickie);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class RightClickie
        extends RightClickModule
        implements IBlockBreakingModule {
            public RightClickie(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public ActionResultType useOn(ItemUseContext context) {
                ItemStack itemStack;
                Direction facing;
                int energyConsumed = this.getEnergyUsage();
                PlayerEntity player = context.func_195999_j();
                World world = context.func_195991_k();
                BlockPos pos = context.func_195995_a();
                if (!player.func_175151_a(pos, facing = context.func_196000_l(), itemStack = context.func_195996_i()) || ElectricItemUtils.getPlayerEnergy((LivingEntity)player) < energyConsumed) {
                    return ActionResultType.PASS;
                }
                int hook = ForgeEventFactory.onHoeUse((ItemUseContext)context);
                if (hook != 0) {
                    return hook > 0 ? ActionResultType.SUCCESS : ActionResultType.FAIL;
                }
                int radius = (int)this.applyPropertyModifiers("radius");
                for (int i = (int)Math.floor(-radius); i < radius; ++i) {
                    for (int j = (int)Math.floor(-radius); j < radius; ++j) {
                        BlockState blockstate;
                        if (i * i + j * j >= radius * radius) continue;
                        BlockPos newPos = pos.func_177982_a(i, 0, j);
                        if (facing == Direction.DOWN || !world.func_175623_d(newPos.func_177984_a()) && !ToolHelpers.blockCheckAndHarvest((PlayerEntity)player, (World)world, (BlockPos)newPos.func_177984_a()) || facing == Direction.DOWN || !world.func_175623_d(newPos.func_177984_a()) || (blockstate = HOE_LOOKUP.get(world.func_180495_p(newPos).func_177230_c())) == null) continue;
                        world.func_184133_a(player, newPos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        if (world.field_72995_K) continue;
                        world.func_180501_a(newPos, blockstate, 11);
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)energyConsumed);
                    }
                }
                return ActionResultType.SUCCESS;
            }

            public boolean onBlockDestroyed(ItemStack itemStack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving, int playerEnergy) {
                if (this.canHarvestBlock(itemStack, state, (PlayerEntity)entityLiving, pos, playerEnergy)) {
                    ElectricItemUtils.drainPlayerEnergy((LivingEntity)entityLiving, (int)this.getEnergyUsage());
                    return true;
                }
                return false;
            }

            public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
                event.setNewSpeed((float)((double)event.getNewSpeed() * this.applyPropertyModifiers("hoeHarvestSpeed")));
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("hoeEnergy");
            }

            @Nonnull
            public ItemStack getEmulatedTool() {
                return new ItemStack((IItemProvider)Items.field_151019_K);
            }
        }
    }
}

