/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.SideSkipPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class FramedPrismBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> side == ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)).func_176734_d();
    public static final SideSkipPredicate SKIP_PREDICATE = (level, pos, state, adjState, side) -> {
        Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        Direction.Axis axis = (Direction.Axis)state.func_177229_b((Property)BlockStateProperties.field_208148_A);
        if (side.func_176740_k() != axis) {
            return false;
        }
        if (adjState.func_203425_a((Block)FBContent.blockFramedPrism.get())) {
            Direction adjFacing = (Direction)adjState.func_177229_b((Property)BlockStateProperties.field_208155_H);
            Direction.Axis adjAxis = (Direction.Axis)adjState.func_177229_b((Property)BlockStateProperties.field_208148_A);
            return adjFacing == facing && adjAxis == axis && SideSkipPredicate.compareState(level, pos, side);
        }
        if (adjState.func_203425_a((Block)FBContent.blockFramedSlopedPrism.get())) {
            Direction adjFacing = (Direction)adjState.func_177229_b((Property)BlockStateProperties.field_208155_H);
            Direction adjOrientation = (Direction)adjState.func_177229_b((Property)PropertyHolder.ORIENTATION);
            return adjFacing == facing && adjOrientation == side.func_176734_d() && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    };

    public FramedPrismBlock() {
        super(BlockType.FRAMED_PRISM);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)PropertyHolder.SOLID, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H, BlockStateProperties.field_208148_A, BlockStateProperties.field_208198_y, PropertyHolder.SOLID, PropertyHolder.GLOWING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction.Axis axis;
        BlockState state = this.func_176223_P();
        Direction face = context.func_196000_l();
        state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)face);
        if (face.func_176740_k() == Direction.Axis.Y) {
            axis = context.func_195992_f().func_176740_k();
        } else {
            Vector3d subHit = Utils.fraction(context.func_221532_j());
            double xz = (face.func_176740_k() == Direction.Axis.X ? subHit.func_82616_c() : subHit.func_82615_a()) - 0.5;
            double y = subHit.func_82617_b() - 0.5;
            axis = Math.max(Math.abs(xz), Math.abs(y)) == Math.abs(xz) ? face.func_176746_e().func_176740_k() : Direction.Axis.Y;
        }
        state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)axis);
        return FramedPrismBlock.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottom = VoxelShapes.func_216384_a((VoxelShape)FramedPrismBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPrismBlock.func_208617_a((double)0.5, (double)0.0, (double)0.0, (double)15.5, (double)4.0, (double)16.0), FramedPrismBlock.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0)}).func_197753_c();
        VoxelShape shapeTop = VoxelShapes.func_216384_a((VoxelShape)FramedPrismBlock.func_208617_a((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPrismBlock.func_208617_a((double)0.5, (double)12.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0), FramedPrismBlock.func_208617_a((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0)}).func_197753_c();
        VoxelShape shapeXZ = VoxelShapes.func_216384_a((VoxelShape)FramedPrismBlock.func_208617_a((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPrismBlock.func_208617_a((double)0.0, (double)0.5, (double)12.0, (double)16.0, (double)15.5, (double)16.0), FramedPrismBlock.func_208617_a((double)0.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0, (double)16.0)}).func_197753_c();
        VoxelShape shapeY = VoxelShapes.func_216384_a((VoxelShape)FramedPrismBlock.func_208617_a((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPrismBlock.func_208617_a((double)0.5, (double)0.0, (double)12.0, (double)15.5, (double)16.0, (double)16.0), FramedPrismBlock.func_208617_a((double)4.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0)}).func_197753_c();
        for (BlockState state : states) {
            Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            Direction.Axis axis = (Direction.Axis)state.func_177229_b((Property)BlockStateProperties.field_208148_A);
            if (axis == facing.func_176740_k()) {
                builder.put((Object)state, (Object)VoxelShapes.func_197868_b());
                continue;
            }
            if (facing.func_176740_k() == Direction.Axis.Y) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, Direction.func_211699_a((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), facing == Direction.UP ? shapeBottom : shapeTop));
                continue;
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, axis == Direction.Axis.Y ? shapeY : shapeXZ));
        }
        return builder.build();
    }
}

