/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;
import xfacthd.framedblocks.common.util.SideSkipPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class SlabEdgeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (!(adjState.func_177230_c() instanceof IFramedBlock)) {
            return false;
        }
        BlockType adjBlock = ((IFramedBlock)adjState.func_177230_c()).getBlockType();
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        switch (adjBlock) {
            case FRAMED_SLAB_EDGE: {
                return this.testAgainstEdge(world, pos, dir, top, adjState, side);
            }
            case FRAMED_SLAB: {
                return this.testAgainstSlab(world, pos, dir, top, adjState, side);
            }
            case FRAMED_DOUBLE_SLAB: {
                return this.testAgainstDoubleSlab(world, pos, dir, top, side);
            }
            case FRAMED_SLAB_CORNER: {
                return this.testAgainstCorner(world, pos, dir, top, adjState, side);
            }
            case FRAMED_PANEL: {
                return this.testAgainstPanel(world, pos, dir, top, adjState, side);
            }
            case FRAMED_DOUBLE_PANEL: {
                return this.testAgainstDoublePanel(world, pos, dir, top, adjState, side);
            }
            case FRAMED_STAIRS: {
                return this.testAgainstStairs(world, pos, dir, top, adjState, side);
            }
            case FRAMED_VERTICAL_STAIRS: {
                return this.testAgainstVerticalStairs(world, pos, dir, top, adjState, side);
            }
            case FRAMED_HALF_STAIRS: {
                return SlabEdgeSkipPredicate.testAgainstHalfStairs(world, pos, dir, top, adjState, side);
            }
            case FRAMED_SLOPE_SLAB: {
                return SlabEdgeSkipPredicate.testAgainstSlopeSlab(world, pos, dir, top, adjState, side);
            }
            case FRAMED_ELEVATED_SLOPE_SLAB: {
                return SlabEdgeSkipPredicate.testAgainstElevatedSlopeSlab(world, pos, dir, top, adjState, side);
            }
            case FRAMED_DOUBLE_SLOPE_SLAB: {
                return SlabEdgeSkipPredicate.testAgainstDoubleSlopeSlab(world, pos, dir, top, adjState, side);
            }
            case FRAMED_INV_DOUBLE_SLOPE_SLAB: {
                return SlabEdgeSkipPredicate.testAgainstInverseDoubleSlopeSlab(world, pos, dir, top, adjState, side);
            }
            case FRAMED_VERTICAL_HALF_STAIRS: {
                return SlabEdgeSkipPredicate.testAgainstVerticalHalfStairs(world, pos, dir, top, adjState, side);
            }
            case FRAMED_SLOPE_PANEL: {
                return SlabEdgeSkipPredicate.testAgainstSlopePanel(world, pos, dir, top, adjState, side);
            }
            case FRAMED_EXTENDED_SLOPE_PANEL: {
                return SlabEdgeSkipPredicate.testAgainstExtendedSlopePanel(world, pos, dir, top, adjState, side);
            }
            case FRAMED_DOUBLE_SLOPE_PANEL: {
                return SlabEdgeSkipPredicate.testAgainstDoubleSlopePanel(world, pos, dir, top, adjState, side);
            }
            case FRAMED_INV_DOUBLE_SLOPE_PANEL: {
                return SlabEdgeSkipPredicate.testAgainstInverseDoubleSlopePanel(world, pos, dir, top, adjState, side);
            }
        }
        return false;
    }

    private boolean testAgainstEdge(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (side == dir && adjDir == side.func_176734_d()) {
            return top == adjTop && SideSkipPredicate.compareState(world, pos, side);
        }
        if (side == dir.func_176746_e() || side == dir.func_176735_f()) {
            return dir == adjDir && top == adjTop && SideSkipPredicate.compareState(world, pos, side);
        }
        if (side.func_176740_k() == Direction.Axis.Y && dir == adjDir) {
            return top != adjTop && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side != dir || top != (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP)) {
            return false;
        }
        return SideSkipPredicate.compareState(world, pos, side);
    }

    private boolean testAgainstDoubleSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, Direction side) {
        if (side != dir) {
            return false;
        }
        Direction face = top ? Direction.UP : Direction.DOWN;
        return SideSkipPredicate.compareState(world, pos, side, face);
    }

    private boolean testAgainstCorner(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (side == dir.func_176746_e() && adjDir == dir || side == dir.func_176735_f() && adjDir == dir.func_176746_e()) {
            return top == adjTop && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstPanel(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side.func_176740_k() != Direction.Axis.Y) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (dir != adjDir) {
            return false;
        }
        if (side == Direction.UP && top || side == Direction.DOWN && !top) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstDoublePanel(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side.func_176740_k() != Direction.Axis.Y) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_NE);
        if (dir != adjDir && dir != adjDir.func_176734_d()) {
            return false;
        }
        if (side == Direction.UP && top || side == Direction.DOWN && !top) {
            return SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        StairsShape adjShape = (StairsShape)adjState.func_177229_b((Property)BlockStateProperties.field_208146_au);
        boolean bl = adjTop = adjState.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.TOP;
        if (top && side == Direction.UP || !top && side == Direction.DOWN) {
            if (adjShape != StairsShape.STRAIGHT || dir != adjDir) {
                return false;
            }
            return top == adjTop && SideSkipPredicate.compareState(world, pos, side);
        }
        if (top == adjTop && side == dir && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.func_176734_d())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstVerticalStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.func_177229_b(PropertyHolder.STAIRS_TYPE));
        if (adjType == StairsType.VERTICAL) {
            return false;
        }
        if (side == dir.func_176735_f() && adjDir == dir || side == dir.func_176746_e() && adjDir == dir.func_176746_e()) {
            return top != adjType.isTop() && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        boolean adjRight = (Boolean)adjState.func_177229_b((Property)PropertyHolder.RIGHT);
        if (adjRight && adjDir == dir.func_176735_f() || !adjRight && adjDir == dir.func_176746_e()) {
            if (side.func_176740_k() == Direction.Axis.Y && side == Direction.DOWN == adjTop && adjTop != top) {
                return SideSkipPredicate.compareState(world, pos, side);
            }
            return side == adjDir && adjTop == top && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP_HALF);
        if (side != dir) {
            return false;
        }
        return adjDir == dir.func_176734_d() && adjTopHalf == top && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstElevatedSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (side != dir) {
            return false;
        }
        return adjDir == dir && adjTop == top && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstDoubleSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP_HALF);
        if (side != dir) {
            return false;
        }
        return (adjDir == dir || adjDir == dir.func_176734_d()) && adjTopHalf == top && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (side != dir) {
            return false;
        }
        return (adjDir == dir && !top || adjDir == dir.func_176734_d() && top) && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstVerticalHalfStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (Utils.isY(side) || side == dir.func_176734_d() || adjTop != top) {
            return false;
        }
        if (side == dir && (adjDir == side.func_176734_d() || adjDir == side.func_176735_f())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (side == dir.func_176746_e() && adjDir == dir.func_176746_e() || side == dir.func_176735_f() && adjDir == dir) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.func_177229_b((Property)PropertyHolder.FRONT);
        if (!adjRot.isVertical() || side != adjRot.withFacing(adjDir)) {
            return false;
        }
        if (top == (adjRot == Rotation.UP) && (adjDir == dir && !adjFront || adjDir == dir.func_176734_d() && adjFront)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!Utils.isY(side) || !top && side != Direction.DOWN || top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        return adjDir == dir && top == (adjRot == Rotation.DOWN) && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstDoubleSlopePanel(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.func_177229_b((Property)PropertyHolder.FRONT);
        if (!adjRot.isVertical() || side.func_176740_k() != adjRot.withFacing(adjDir).func_176740_k()) {
            return false;
        }
        if (top == (side == Direction.UP) && (adjDir == dir && !adjFront || adjDir == dir.func_176734_d() && adjFront)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjUp;
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        if (!adjRot.isVertical() || side.func_176740_k() != adjRot.withFacing(adjDir).func_176740_k()) {
            return false;
        }
        boolean bl = adjUp = adjRot == Rotation.UP;
        if (!adjUp && (!top && adjDir == dir.func_176734_d() || top && adjDir == dir)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (adjUp && (!top && adjDir == dir || top && adjDir == dir.func_176734_d())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }
}

