/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.net;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.common.tileentity.FramedSignTileEntity;

public class SignUpdatePacket {
    private final BlockPos pos;
    private final String[] lines;

    public SignUpdatePacket(BlockPos pos, String[] lines) {
        this.pos = pos;
        this.lines = lines;
    }

    public SignUpdatePacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        int count = buffer.readByte();
        this.lines = new String[count];
        for (int i = 0; i < count; ++i) {
            this.lines[i] = buffer.func_150789_c(384);
        }
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeByte(this.lines.length);
        for (String line : this.lines) {
            buffer.func_180714_a(line);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerWorld world = player.func_71121_q();
            if (world.func_175667_e(this.pos) && (te = world.func_175625_s(this.pos)) instanceof FramedSignTileEntity) {
                FramedSignTileEntity sign = (FramedSignTileEntity)te;
                if (sign.getEditingPlayer() != player) {
                    FramedBlocks.LOGGER.warn("Player " + player + " tried to edit sign at " + this.pos);
                    return;
                }
                for (int i = 0; i < this.lines.length; ++i) {
                    String line = TextFormatting.func_110646_a((String)this.lines[i]);
                    sign.setLine(i, (ITextComponent)new StringTextComponent(line != null ? line : ""));
                }
            }
        });
        return true;
    }
}

